/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.InterpreterContainerInitializer;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathEntry;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntryResolver2;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterRuntimeBuildpathEntryResolver
implements IRuntimeBuildpathEntryResolver2 {
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        String nature = configuration.getAttribute("nature", null);
        IInterpreterInstall InterpreterEnvironment = null;
        InterpreterEnvironment = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? InterpreterContainerInitializer.resolveInterpreter(nature, entry.getPath()) : ScriptRuntime.computeInterpreterInstall(configuration);
        if (InterpreterEnvironment == null) {
            return new IRuntimeBuildpathEntry[0];
        }
        return this.resolveLibraryLocations(InterpreterEnvironment, entry.getBuildpathProperty());
    }

    private String getNatureFromProject(IScriptProject project) {
        try {
            return DLTKLanguageManager.getLanguageToolkit((IModelElement)project).getNatureId();
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.log(e);
            return null;
        }
    }

    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        IInterpreterInstall InterpreterEnvironment = null;
        InterpreterEnvironment = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? InterpreterContainerInitializer.resolveInterpreter(this.getNatureFromProject(project), entry.getPath()) : ScriptRuntime.getInterpreterInstall(project);
        if (InterpreterEnvironment == null) {
            return new IRuntimeBuildpathEntry[0];
        }
        return this.resolveLibraryLocations(InterpreterEnvironment, entry.getBuildpathProperty());
    }

    protected IRuntimeBuildpathEntry[] resolveLibraryLocations(IInterpreterInstall Interpreter, int kind) {
        LibraryLocation[] libs = Interpreter.getLibraryLocations();
        LibraryLocation[] defaultLibs = Interpreter.getInterpreterInstallType().getDefaultLibraryLocations(Interpreter.getInstallLocation());
        if (libs == null) {
            libs = defaultLibs;
        }
        ArrayList<IRuntimeBuildpathEntry> resolvedEntries = new ArrayList<IRuntimeBuildpathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            IPath systemLibraryPath = libs[i].getLibraryPath();
            if (systemLibraryPath.toFile().exists()) {
                resolvedEntries.add(this.resolveLibraryLocation(Interpreter, libs[i], kind));
            }
            ++i;
        }
        return resolvedEntries.toArray(new IRuntimeBuildpathEntry[resolvedEntries.size()]);
    }

    public static boolean isSameArchives(LibraryLocation[] libs, LibraryLocation[] defaultLibs) {
        if (libs.length != defaultLibs.length) {
            return false;
        }
        int i = 0;
        while (i < defaultLibs.length) {
            LibraryLocation def = defaultLibs[i];
            LibraryLocation lib = libs[i];
            if (!def.getLibraryPath().equals((Object)lib.getLibraryPath())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IInterpreterInstall resolveInterpreterInstall(String lang, IBuildpathEntry entry) {
        if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER)) {
            try {
                return InterpreterContainerInitializer.resolveInterpreter(lang, entry.getPath());
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    public boolean isInterpreterInstallReference(String lang, IBuildpathEntry entry) {
        return entry.getEntryKind() == 5 && entry.getPath().segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER);
    }

    private IRuntimeBuildpathEntry resolveLibraryLocation(IInterpreterInstall Interpreter, LibraryLocation location, int kind) {
        IPath libraryPath = location.getLibraryPath();
        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
        IBuildpathEntry bpe = DLTKCore.newLibraryEntry((IPath)libraryPath, (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (boolean)false, (boolean)false);
        RuntimeBuildpathEntry resolved = new RuntimeBuildpathEntry(bpe);
        resolved.setBuildpathProperty(kind);
        return resolved;
    }
}

