/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugTargetListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManager;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManagerListener;
import org.eclipse.dltk.internal.debug.core.model.ScriptBreakpointManager;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptThreadManager;

public class ScriptDebugTarget
extends ScriptDebugElement
implements IScriptDebugTarget,
IScriptThreadManagerListener {
    private static final String LAUNCH_CONFIGURATION_ATTR_PROJECT = "project";
    private static final String LAUNCH_CONFIGURATION_ATTR_BREAK_ON_FIRST_LINE = "enableBreakOnFirstLine";
    private static final int THREAD_TERMINATION_TIMEOUT = 5000;
    private final ListenerList listeners;
    private IScriptStreamProxy streamProxy;
    private IProcess process;
    private final ILaunch launch;
    private String name;
    private boolean disconnected;
    private final IScriptThreadManager threadManager;
    private final ScriptBreakpointManager breakpointManager;
    private final IDbgpService dbgpService;
    private final String sessionId;
    private final String mondelId;
    static WeakHashMap targets = new WeakHashMap();
    private String[] stepFilters;
    private boolean useStepFilters;
    private final Object terminatedLock = new Object();
    private boolean terminated = false;
    private boolean initialized = false;
    private boolean retrieveGlobalVariables;
    private boolean retrieveClassVariables;
    private boolean retrieveLocalVariables;

    public static List getAllTargets() {
        return new ArrayList(targets.keySet());
    }

    public ScriptDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process) throws CoreException {
        this.mondelId = modelId;
        this.listeners = new ListenerList();
        this.process = process;
        this.launch = launch;
        this.threadManager = new ScriptThreadManager(this);
        this.sessionId = sessionId;
        this.dbgpService = dbgpService;
        this.dbgpService.registerAcceptor(this.sessionId, this.threadManager);
        this.disconnected = false;
        this.breakpointManager = new ScriptBreakpointManager(this);
        this.threadManager.addListener(this);
        DebugEventHelper.fireCreateEvent(this);
        targets.put(this, "");
    }

    public void shutdown() {
        try {
            this.terminate();
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getModelIdentifier() {
        return this.mondelId;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess process) {
        this.process = process;
    }

    public boolean hasThreads() throws DebugException {
        return this.threadManager.hasThreads();
    }

    public IThread[] getThreads() throws DebugException {
        return this.threadManager.getThreads();
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public boolean isTerminated() {
        return this.threadManager.isTerminated();
    }

    protected boolean waitTermianted() {
        int all = 0;
        while (all < 5000) {
            try {
                Thread.sleep(400L);
                all += 400;
            }
            catch (InterruptedException interruptedException) {}
            if (!this.threadManager.isTerminated()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        Object object = this.terminatedLock;
        synchronized (object) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        this.dbgpService.unregisterAcceptor(this.sessionId);
        this.threadManager.sendTerminationRequest();
        if (!this.waitTermianted() && this.process != null && this.process.canTerminate()) {
            this.process.terminate();
        }
        this.threadManager.removeListener(this);
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.removeBreakpointListener((IBreakpointListener)this);
        manager.removeBreakpointManagerListener((IBreakpointManagerListener)this.breakpointManager);
        DebugEventHelper.fireTerminateEvent(this);
    }

    public boolean canSuspend() {
        return this.threadManager.canSuspend();
    }

    public boolean isSuspended() {
        return this.threadManager.isSuspended();
    }

    public void suspend() throws DebugException {
        this.threadManager.suspend();
    }

    public boolean canResume() {
        return this.threadManager.canResume();
    }

    public void resume() throws DebugException {
        this.threadManager.resume();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        this.disconnected = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IScriptVariable findVariable(String variableName) throws DebugException {
        return null;
    }

    public int getRequestTimeout() {
        return 0;
    }

    public void setRequestTimeout(int timeout) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.breakpointManager.breakpointAdded(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointChanged(breakpoint, delta);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointRemoved(breakpoint, delta);
    }

    public IScriptStreamProxy getStreamProxy() {
        return this.streamProxy;
    }

    public void setStreamProxy(IScriptStreamProxy proxy) {
        this.streamProxy = proxy;
    }

    public void threadAccepted(IScriptThread thread, boolean first) {
        if (first) {
            DebugEventHelper.fireExtendedEvent(this, 2);
            this.breakpointManager.setupDeferredBreakpoints();
            IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
            manager.addBreakpointListener((IBreakpointListener)this);
            manager.addBreakpointManagerListener((IBreakpointManagerListener)this.breakpointManager);
            this.initialized = true;
            this.fireTargetInitialized();
        }
    }

    public void allThreadsTerminated() {
        try {
            if (this.streamProxy != null) {
                this.streamProxy.close();
            }
            this.terminate();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Debugging engine (id = " + this.sessionId + ")";
    }

    public void runToLine(URI uri, int lineNumber) throws DebugException {
        this.breakpointManager.setBreakpointUntilFirstSuspend(uri, lineNumber);
        this.resume();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void fireTargetInitialized() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptDebugTargetListener)list[i]).targetInitialized();
            ++i;
        }
    }

    public void addListener(IScriptDebugTargetListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IScriptDebugTargetListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.breakpointManager.supportsBreakpoint(breakpoint);
    }

    public void setFilters(String[] activeFilters) {
        this.stepFilters = activeFilters;
    }

    public String[] getFilters() {
        if (this.stepFilters != null) {
            return this.stepFilters;
        }
        return new String[0];
    }

    public boolean isUseStepFilters() {
        return this.useStepFilters;
    }

    public void setUseStepFilters(boolean useStepFilters) {
        this.useStepFilters = useStepFilters;
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        block3: {
            ILaunchConfiguration configuration = this.getLaunch().getLaunchConfiguration();
            String projectName = null;
            try {
                projectName = configuration.getAttribute(LAUNCH_CONFIGURATION_ATTR_PROJECT, null);
                if (projectName != null && (projectName = projectName.trim()).length() > 0) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    IScriptProject scriptProject = DLTKCore.create((IProject)project);
                    IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
                    return toolkit;
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean breakOnFirstLineEnabled() {
        try {
            return this.launch.getLaunchConfiguration().getAttribute(LAUNCH_CONFIGURATION_ATTR_BREAK_ON_FIRST_LINE, false);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public void toggleGlobalVariables(boolean enabled) {
        this.retrieveGlobalVariables = enabled;
        this.threadManager.refreshThreads();
    }

    public void toggleClassVariables(boolean enabled) {
        this.retrieveClassVariables = enabled;
        this.threadManager.refreshThreads();
    }

    public void toggleLocalVariables(boolean enabled) {
        this.retrieveLocalVariables = enabled;
        this.threadManager.refreshThreads();
    }

    public boolean retrieveClassVariables() {
        return this.retrieveClassVariables;
    }

    public boolean retrieveGlobalVariables() {
        return this.retrieveGlobalVariables;
    }

    public boolean retrieveLocalVariables() {
        return this.retrieveLocalVariables;
    }

    public String getConsoleEncoding() {
        String encoding = "UTF-8";
        try {
            encoding = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", encoding);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public void setScriptDebugThreadConfigurator(IScriptDebugThreadConfigurator configurator) {
        this.threadManager.setScriptThreadConfigurator(configurator);
    }
}

