/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.DbgpTransactionManager;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.w3c.dom.Element;

public class DbgpBaseCommands {
    private final IDbgpCommunicator communicator;

    public DbgpBaseCommands(IDbgpCommunicator communicator) {
        this.communicator = communicator;
    }

    protected DbgpRequest createRequest(String command) {
        DbgpRequest request = new DbgpRequest(command);
        request.addOption("-i", DbgpTransactionManager.getInstance().generateId());
        return request;
    }

    protected Element communicate(DbgpRequest request) throws DbgpException {
        return this.communicator.communicate(request);
    }

    protected void send(DbgpRequest request) throws DbgpException {
        this.communicator.send(request);
    }
}

