/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKAssociationManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptFileConfigurator;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.DLTKAssociationManager;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.NopAssociationManager;
import org.eclipse.dltk.internal.core.ScriptFileConfiguratorManager;

public class DLTKContentTypeManager {
    public static final QualifiedName DLTK_VALID = new QualifiedName("org.eclipse.dltk.core", "valid");
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_CONTENT = false;
    private static final Map<IDLTKLanguageToolkit, IContentType[]> contentTypesCache = new HashMap<IDLTKLanguageToolkit, IContentType[]>();
    private static IContentTypeManager.IContentTypeChangeListener changeListener = null;
    private static final Map<IDLTKLanguageToolkit, IDLTKAssociationManager> associationManagerCache = new HashMap<IDLTKLanguageToolkit, IDLTKAssociationManager>();
    private static IResourceChangeListener listener = null;

    private static void log(String message, Object input) {
        if (input != null) {
            String className = input.getClass().getName();
            int pos = className.lastIndexOf(46);
            if (pos > 0) {
                className = className.substring(pos + 1);
            }
            System.out.println(String.valueOf(message) + ' ' + input + ':' + className);
        }
    }

    public static boolean isValidFileNameForContentType(IDLTKLanguageToolkit toolkit, String name) {
        IDLTKAssociationManager associationManager = DLTKContentTypeManager.getAssociationManager(toolkit);
        if (associationManager.isAssociatedWith(name)) {
            return true;
        }
        IContentType[] contentTypes = DLTKContentTypeManager.getContentTypes(toolkit);
        return DLTKContentTypeManager.isValidFileNameForContentType(contentTypes, name);
    }

    public static boolean isValidFileNameForContentType(IDLTKLanguageToolkit toolkit, IPath path) {
        File file;
        IDLTKAssociationManager associationManager = DLTKContentTypeManager.getAssociationManager(toolkit);
        if (associationManager.isAssociatedWith(path.lastSegment())) {
            return true;
        }
        IContentType[] contentTypes = DLTKContentTypeManager.getContentTypes(toolkit);
        if (DLTKContentTypeManager.isValidFileNameForContentType(contentTypes, path.lastSegment())) {
            return true;
        }
        if (EnvironmentPathUtils.isFull(path)) {
            IFileHandle file2 = EnvironmentPathUtils.getFile(path);
            if (file2 != null && file2.isFile()) {
                if (file2.getEnvironment().isLocal()) {
                    File localFile = new File(file2.toOSString());
                    return toolkit.canValidateContent(file2) && DLTKContentTypeManager.validateLocalFileContent(contentTypes, localFile);
                }
                return toolkit.canValidateContent(file2) && DLTKContentTypeManager.validateRemoteFileContent(contentTypes, file2);
            }
            return false;
        }
        if (path.isAbsolute() && (file = path.toFile()).isFile()) {
            return toolkit.canValidateContent(file) && DLTKContentTypeManager.validateLocalFileContent(contentTypes, file);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource member = root.findMember(path);
        return member != null && member.getType() == 1 && DLTKContentTypeManager.validateResourceContent(contentTypes, (IFile)member);
    }

    private static boolean validateRemoteFileContent(IContentType[] derived, IFileHandle file) {
        int i = 0;
        while (i < derived.length) {
            block9: {
                IContentType type = derived[i];
                BufferedInputStream stream = null;
                try {
                    stream = new BufferedInputStream(file.openInputStream(null), 2048);
                    IContentDescription description = type.getDescriptionFor((InputStream)stream, IContentDescription.ALL);
                    if (description != null && DLTKContentTypeManager.checkDescription(type, description)) {
                        DLTKContentTypeManager.closeStream(stream);
                        return true;
                    }
                }
                catch (IOException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                    break block9;
                }
                finally {
                    DLTKContentTypeManager.closeStream(stream);
                }
                DLTKContentTypeManager.closeStream(stream);
            }
            ++i;
        }
        return false;
    }

    private static boolean validateLocalFileContent(IContentType[] derived, File file) {
        int i = 0;
        while (i < derived.length) {
            block9: {
                IContentType type = derived[i];
                BufferedInputStream stream = null;
                try {
                    stream = new BufferedInputStream(new FileInputStream(file));
                    IContentDescription description = type.getDescriptionFor((InputStream)stream, IContentDescription.ALL);
                    if (description != null && DLTKContentTypeManager.checkDescription(type, description)) {
                        DLTKContentTypeManager.closeStream(stream);
                        return true;
                    }
                }
                catch (IOException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                    break block9;
                }
                finally {
                    DLTKContentTypeManager.closeStream(stream);
                }
                DLTKContentTypeManager.closeStream(stream);
            }
            ++i;
        }
        return false;
    }

    private static void closeStream(InputStream stream) {
        block3: {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean isValidFileNameForContentType(IContentType[] contentTypes, String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < contentTypes.length) {
            IContentType type = contentTypes[i];
            if (type.isAssociatedWith(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidResourceForContentType(IDLTKLanguageToolkit toolkit, IResource resource) {
        if (!(resource instanceof IFile)) {
            return false;
        }
        IStatus status = toolkit.validateSourceModule(resource);
        if (status.getSeverity() != 0) {
            return false;
        }
        IDLTKAssociationManager associationManager = DLTKContentTypeManager.getAssociationManager(toolkit);
        if (associationManager.isAssociatedWith(resource.getName())) {
            block11: {
                try {
                    DLTKContentTypeManager.configureAsScript((IFile)resource, toolkit.getNatureId());
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block11;
                    e.printStackTrace();
                }
            }
            return true;
        }
        IContentType[] contentTypes = DLTKContentTypeManager.getContentTypes(toolkit);
        if (DLTKContentTypeManager.isValidFileNameForContentType(contentTypes, resource.getName())) {
            return true;
        }
        if (!toolkit.canValidateContent(resource)) {
            return false;
        }
        try {
            String value = resource.getPersistentProperty(DLTK_VALID);
            if (value != null) {
                return TRUE_VALUE.equals(value);
            }
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        boolean result = DLTKContentTypeManager.validateResourceContent(contentTypes, (IFile)resource);
        DLTKContentTypeManager.setValidScript((IFile)resource, toolkit.getNatureId(), result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean validateResourceContent(IContentType[] contentTypes, IFile file) {
        block15: {
            try {
                IContentDescription descr;
                if (contentTypes.length != 0 && file.exists() && (descr = file.getContentDescription()) != null && descr.getContentType().isKindOf(contentTypes[0])) {
                    return true;
                }
            }
            catch (CoreException e1) {
                if (!DLTKCore.DEBUG) break block15;
                e1.printStackTrace();
            }
        }
        try {
            int i = 0;
            while (true) {
                if (i >= contentTypes.length) {
                    return false;
                }
                IContentType type = contentTypes[i];
                InputStream contents = ModelManager.getModelManager().getFileCache().getContentsIfCached(file);
                if (contents == null) {
                    contents = new BufferedInputStream(file.getContents(), 2048);
                }
                try {
                    IContentDescription description = type.getDescriptionFor(contents, IContentDescription.ALL);
                    if (description != null && DLTKContentTypeManager.checkDescription(type, description)) {
                        return true;
                    }
                }
                catch (IOException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                finally {
                    DLTKContentTypeManager.closeStream(contents);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            if (!DLTKCore.DEBUG) return false;
            e.printStackTrace();
        }
        return false;
    }

    private static void setValidScript(IFile file, String natureId, boolean value) {
        block3: {
            try {
                file.setPersistentProperty(DLTK_VALID, value ? TRUE_VALUE : FALSE_VALUE);
                if (value) {
                    DLTKContentTypeManager.configureAsScript(file, natureId);
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private static void configureAsScript(IFile file, String natureId) throws CoreException {
        IScriptFileConfigurator[] configurators = ScriptFileConfiguratorManager.get(natureId);
        if (configurators != null) {
            int i = 0;
            while (i < configurators.length) {
                configurators[i].configure(file);
                ++i;
            }
        }
    }

    private static boolean checkDescription(IContentType type, IContentDescription description) {
        Object object = description.getProperty(DLTK_VALID);
        if (object != null && Boolean.TRUE.equals(object)) {
            IContentType contentType = description.getContentType();
            return contentType.isKindOf(type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IContentType[] getContentTypes(IDLTKLanguageToolkit toolkit) {
        IContentType[] result;
        Map<IDLTKLanguageToolkit, IContentType[]> map = contentTypesCache;
        synchronized (map) {
            result = contentTypesCache.get(toolkit);
        }
        if (result != null) {
            return result;
        }
        IContentTypeManager manager = Platform.getContentTypeManager();
        Map<IDLTKLanguageToolkit, IContentType[]> map2 = contentTypesCache;
        synchronized (map2) {
            if (changeListener == null) {
                changeListener = new IContentTypeManager.IContentTypeChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
                        Map map = contentTypesCache;
                        synchronized (map) {
                            contentTypesCache.clear();
                        }
                    }
                };
                manager.addContentTypeChangeListener(changeListener);
            }
        }
        IContentType masterType = manager.getContentType(toolkit.getLanguageContentType());
        if (masterType != null) {
            HashSet<IContentType> selected = new HashSet<IContentType>();
            IContentType[] iContentTypeArray = manager.getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type = iContentTypeArray[n2];
                if (type.isKindOf(masterType)) {
                    selected.add(type);
                }
                ++n2;
            }
            result = selected.toArray(new IContentType[selected.size()]);
            int i = 1;
            while (i < result.length) {
                if (result[i] == masterType) {
                    IContentType temp = result[0];
                    result[0] = result[i];
                    result[i] = temp;
                    break;
                }
                ++i;
            }
        } else {
            result = new IContentType[]{};
        }
        Map<IDLTKLanguageToolkit, IContentType[]> map3 = contentTypesCache;
        synchronized (map3) {
            contentTypesCache.put(toolkit, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDLTKAssociationManager getAssociationManager(IDLTKLanguageToolkit toolkit) {
        IDLTKAssociationManager manager;
        Map<IDLTKLanguageToolkit, IDLTKAssociationManager> map = associationManagerCache;
        synchronized (map) {
            manager = associationManagerCache.get(toolkit);
        }
        if (manager != null) {
            return manager;
        }
        manager = toolkit.getPreferenceQualifier() != null ? new DLTKAssociationManager(toolkit.getNatureId(), toolkit.getPreferenceQualifier()) : new NopAssociationManager();
        map = associationManagerCache;
        synchronized (map) {
            associationManagerCache.put(toolkit, manager);
        }
        return manager;
    }

    public static void installListener() {
        if (listener == null) {
            listener = new ResetScriptValidPropertyListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 1);
        }
    }

    public static void uninstallListener() {
        if (listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
            listener = null;
        }
    }

    private static class ResetScriptValidPropertyListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResetScriptValidPropertyListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            block2: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() == 4 && (delta.getFlags() & 0x40100) != 0) {
                    resource.setPersistentProperty(DLTK_VALID, null);
                }
                return false;
            }
            return true;
        }
    }
}

