/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.ModelManager;

public class SourceIndexer
extends AbstractIndexer {
    static long maxWorkTime = 0L;

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        long started = System.currentTimeMillis();
        SourceIndexerRequestor requestor = this.document.requestor;
        String documentPath = this.document.getPath();
        Path path = new Path(documentPath);
        ISourceElementParser parser = this.document.parser;
        if (!this.document.isExternal()) {
            IProject project = this.document.getProject();
            if (project == null) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            }
            IScriptProject scriptProject = DLTKCore.create(project);
            if (requestor == null) {
                requestor = ModelManager.getModelManager().indexManager.getSourceRequestor(scriptProject);
            }
            requestor.setIndexer(this);
            if (parser == null) {
                parser = ModelManager.getModelManager().indexManager.getSourceElementParser(scriptProject);
            }
            parser.setRequestor(requestor);
            String pkgName = "";
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            ISourceModule module = null;
            if (file.exists() && (module = (ISourceModule)DLTKCore.create(file)) != null) {
                IScriptFolder folder = (IScriptFolder)module.getParent();
                pkgName = folder.getElementName();
            }
            requestor.setPackageName(pkgName);
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {}
            if (source == null || name == null) {
                return;
            }
            ISourceModuleInfoCache.ISourceModuleInfo info = null;
            ISourceModuleInfoCache cache = ModelManager.getModelManager().getSourceModuleInfoCache();
            if (module != null) {
                info = cache.get(module);
            }
            parser.parseSourceModule(source, info, name);
        } else {
            ISourceModuleInfoCache.ISourceModuleInfo info;
            char[] name;
            char[] source;
            block22: {
                if (parser == null || requestor == null) {
                    return;
                }
                parser.setRequestor(requestor);
                requestor.setIndexer(this);
                String ppath = path.toString();
                if (DLTKCore.DEBUG) {
                    System.err.println("TODO: Correct me please...");
                }
                String pkgName = new Path(ppath.substring(ppath.indexOf("|") + 1)).removeLastSegments(1).toString();
                requestor.setPackageName(pkgName);
                source = null;
                name = null;
                try {
                    source = this.document.getCharContents();
                    name = documentPath.toCharArray();
                }
                catch (Exception exception) {}
                if (source == null || name == null) {
                    return;
                }
                info = null;
                if (this.document.getProject() != null) {
                    IProject project = this.document.getProject();
                    IScriptProject scriptProject = DLTKCore.create(project);
                    try {
                        IPath fragmentRelativePath;
                        IScriptFolder folder;
                        ISourceModule module;
                        IProjectFragment[] fragments = scriptProject.getProjectFragments();
                        IModelElement frag = null;
                        int i = 0;
                        while (i < fragments.length) {
                            IPath fragmentPath = EnvironmentPathUtils.getLocalPath(fragments[i].getPath());
                            if (fragments[i].isExternal() && fragmentPath.isPrefixOf(this.document.fullPath)) {
                                frag = frag != null && frag.getPath().isPrefixOf(fragments[i].getPath()) ? fragments[i] : fragments[i];
                            }
                            ++i;
                        }
                        if (frag != null && (module = (folder = frag.getScriptFolder((fragmentRelativePath = this.document.fullPath.removeFirstSegments(frag.getPath().segmentCount())).removeLastSegments(1))).getSourceModule(this.document.fullPath.lastSegment())).exists()) {
                            info = ModelManager.getModelManager().getSourceModuleInfoCache().get(module);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block22;
                        e.printStackTrace();
                    }
                }
            }
            parser.parseSourceModule(source, info, name);
            long ended = System.currentTimeMillis();
            if (ended - started > maxWorkTime) {
                maxWorkTime = ended - started;
            }
        }
    }
}

