/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.environment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;

public class EFSFileHandle
implements IFileHandle {
    private IFileStore file;
    private IEnvironment environment;

    public EFSFileHandle(IEnvironment env, IFileStore file) {
        this.environment = env;
        this.file = file;
    }

    public boolean exists() {
        try {
            return this.file.fetchInfo().exists();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public String toOSString() {
        return this.getPath().toString();
    }

    public String getCanonicalPath() {
        return this.toOSString();
    }

    public IFileHandle getChild(String childname) {
        return new EFSFileHandle(this.environment, this.file.getChild((IPath)new Path(childname)));
    }

    public IFileHandle[] getChildren() {
        try {
            IFileStore[] files = this.file.childStores(0, null);
            IFileHandle[] children = new IFileHandle[files.length];
            int i = 0;
            while (i < files.length) {
                children[i] = new EFSFileHandle(this.environment, files[i]);
                ++i;
            }
            return children;
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public URI toURI() {
        return this.file.toURI();
    }

    public String getName() {
        return this.file.getName();
    }

    public IFileHandle getParent() {
        IFileStore parent = this.file.getParent();
        if (parent == null) {
            return null;
        }
        return new EFSFileHandle(this.environment, parent);
    }

    public IPath getPath() {
        return new Path(this.file.toURI().getPath());
    }

    public boolean isDirectory() {
        return this.file.fetchInfo().isDirectory();
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isSymlink() {
        return this.file.fetchInfo().getAttribute(32);
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        try {
            return this.file.openInputStream(0, monitor);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EFSFileHandle) {
            EFSFileHandle anotherFile = (EFSFileHandle)obj;
            return this.file.equals(anotherFile.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.environment.convertPathToString(this.getPath());
    }

    public long lastModified() {
        return this.file.fetchInfo().getLastModified();
    }

    public long length() {
        return this.file.fetchInfo().getLength();
    }

    public IPath getFullPath() {
        return EnvironmentPathUtils.getFullPath(this.environment, this.getPath());
    }

    public String getEnvironmentId() {
        return this.environment.getId();
    }
}

