/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TodoTaskSimpleParser;
import org.eclipse.dltk.core.DLTKCore;

public class TodoTaskAstParser
extends TodoTaskSimpleParser {
    private static final int ALLOC_INCREMENT = 1024;
    private int[] ranges = new int[1024];
    private int rangeCount = 0;

    public TodoTaskAstParser(ITaskReporter taskReporter, ITodoTaskPreferences preferences, ModuleDeclaration module) {
        super(taskReporter, preferences);
        if (this.isValid()) {
            this.processNodes(module);
        }
    }

    protected void addRange(int sourceStart, int sourceEnd) {
        if (this.rangeCount * 2 >= this.ranges.length) {
            int[] newArray = new int[this.ranges.length + 1024];
            System.arraycopy(this.ranges, 0, newArray, 0, this.ranges.length);
            this.ranges = newArray;
        }
        this.ranges[this.rangeCount * 2] = sourceStart;
        this.ranges[this.rangeCount * 2 + 1] = sourceEnd;
        ++this.rangeCount;
    }

    private boolean checkRange(int location) {
        int i = 0;
        while (i < this.rangeCount) {
            if (location >= this.ranges[i * 2] && location < this.ranges[i * 2 + 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void processNodes(ModuleDeclaration module) {
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (TodoTaskAstParser.this.isSimpleNode(node)) {
                    TodoTaskAstParser.this.addRange(node.sourceStart(), node.sourceEnd());
                }
                return true;
            }
        };
        try {
            module.traverse(visitor);
        }
        catch (Exception e) {
            DLTKCore.error("Unexpected error", e);
        }
    }

    protected boolean isSimpleNode(ASTNode node) {
        return node instanceof Literal;
    }

    protected int findCommentStart(char[] content, int begin, int end) {
        int i = begin;
        while (i < end) {
            if (content[i] == '#' && this.checkRange(i)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }
}

