/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.ui.editor.saveparticipant.IPostSaveListener;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.FormatterSyntaxProblemException;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.ui.util.CodeGeneration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatSaveParticipant
implements IPostSaveListener {
    static final String ID = "CodeFormat";
    static final String EDITOR_SAVE_PARTICIPANT_PREFIX = "editor_save_participant_";

    public String getName() {
        return "Format source code";
    }

    public String getId() {
        return ID;
    }

    public boolean isEnabled(ISourceModule compilationUnit) {
        return new PreferencesLookupDelegate(compilationUnit.getScriptProject().getProject()).getBoolean("org.eclipse.dltk.javascript.ui", EDITOR_SAVE_PARTICIPANT_PREFIX + this.getId());
    }

    public boolean needsChangedRegions(ISourceModule compilationUnit) throws CoreException {
        return false;
    }

    public void saved(ISourceModule compilationUnit, IRegion[] changedRegions, IProgressMonitor monitor) throws CoreException {
        Document document = new Document(compilationUnit.getSource());
        IScriptFormatterFactory factory = ScriptFormatterManager.getSelected((String)"org.eclipse.dltk.javascript.core.nature", (IProject)compilationUnit.getScriptProject().getProject());
        if (factory != null) {
            IScriptFormatter formatter = factory.createFormatter(CodeGeneration.getLineDelimiterUsed((IModelElement)compilationUnit), factory.retrievePreferences((IPreferencesLookupDelegate)new PreferencesLookupDelegate(compilationUnit.getScriptProject().getProject())));
            try {
                TextEdit edit = formatter.format(document.get(), 0, document.getLength(), 0);
                if (edit != null) {
                    SourceModuleChange change = new SourceModuleChange("Format " + compilationUnit.getElementName(), compilationUnit);
                    change.setSaveMode(4);
                    change.setEdit(edit);
                    change.perform(monitor);
                }
            }
            catch (FormatterSyntaxProblemException e) {
                return;
            }
            catch (FormatterException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.ui", e.toString(), (Throwable)e));
            }
            catch (MalformedTreeException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.ui", e.toString(), (Throwable)e));
            }
        }
    }
}

