/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ContainerType;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.WorkbenchAdaptable;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageFragment;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesFragment;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryContainerElement
extends WorkbenchAdaptable {
    public LibraryContainerElement(SelectionDialogInput input) {
        super(input);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.LIBRARIES;
    }

    @Override
    public Object[] getChildren() {
        Set<IScriptProject> projects = this.input.collectProjects();
        Set<IProjectFragment> libraries = LibraryContainerElement.collectExternalFragments(projects);
        return libraries.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return DLTKPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel(Object o) {
        return PreferenceMessages.InstrumentationLabelProvider_Libraries;
    }

    public static Set<IProjectFragment> collectExternalFragments(Set<IScriptProject> projects) {
        HashSet<IProjectFragment> libraries = new HashSet<IProjectFragment>();
        for (IScriptProject project : projects) {
            try {
                IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
                int n = iProjectFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectFragment fragment = iProjectFragmentArray[n2];
                    if (LibraryContainerElement.isValid(fragment)) {
                        libraries.add(fragment);
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return libraries;
    }

    public static boolean isValid(IProjectFragment fragment) {
        return fragment.isExternal() && !fragment.isBuiltin() && !(fragment instanceof TclPackageFragment) && !(fragment instanceof TclSourcesFragment);
    }
}

