/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.typeinfo.E4XTypes;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRConstructor;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoResourceSet;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.Constructor;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.RType;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableReference;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TypeUtil {
    private static final String PROXY_SCHEME = "proxy";
    private static final String PROXY_OPAQUE_PART = "dltk/javascript/typeinfo/type";

    @Nullable
    public static SimpleType ref(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        SimpleType ref = TypeInfoModelFactory.eINSTANCE.createSimpleType();
        ref.setTarget(type);
        return ref;
    }

    @Nullable
    public static ClassType classType(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        ClassType ref = TypeInfoModelFactory.eINSTANCE.createClassType();
        ref.setTarget(type);
        return ref;
    }

    public static JSType ref(String typeName) {
        return TypeUtil.ref(TypeUtil.type(typeName));
    }

    public static Type type(String typeName) {
        Type type = TypeInfoModelLoader.getInstance().getType(typeName);
        if (type != null) {
            return type;
        }
        return TypeUtil.createProxy(typeName);
    }

    public static ArrayType arrayOf(String itemType) {
        return TypeUtil.arrayOf(TypeUtil.ref(itemType));
    }

    public static ArrayType arrayOf(JSType itemType) {
        ArrayType arrayType = TypeInfoModelFactory.eINSTANCE.createArrayType();
        arrayType.setItemType(itemType != null ? itemType : TypeUtil.ref(Types.OBJECT));
        return arrayType;
    }

    public static MapType mapOf(String keyType, String valueType) {
        return TypeUtil.mapOf(keyType != null ? TypeUtil.ref(keyType) : null, TypeUtil.ref(valueType));
    }

    public static MapType mapOf(JSType keyType, JSType valueType) {
        MapType mapType = TypeInfoModelFactory.eINSTANCE.createMapType();
        mapType.setKeyType(keyType != null ? keyType : TypeUtil.ref(Types.STRING));
        mapType.setValueType(valueType != null ? valueType : TypeUtil.ref(Types.OBJECT));
        return mapType;
    }

    public static ParameterizedType genericType(String baseType, JSType ... typeParameters) {
        return TypeUtil.parameterizedType(TypeUtil.type(baseType), typeParameters);
    }

    public static ParameterizedType parameterizedType(Type targetType, JSType ... typeParameters) {
        ParameterizedType genericType = TypeInfoModelFactory.eINSTANCE.createParameterizedType();
        genericType.setTarget(targetType);
        JSType[] jSTypeArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JSType typeParameter = jSTypeArray[n2];
            genericType.getActualTypeArguments().add((Object)typeParameter);
            ++n2;
        }
        return genericType;
    }

    public static IRType extractArrayItemType(IRType type) {
        if (type instanceof IRArrayType) {
            return ((IRArrayType)type).getItemType();
        }
        if (type instanceof IRMapType) {
            return ((IRMapType)type).getValueType();
        }
        if (type != null && type.getName().equals("XML")) {
            return type;
        }
        if (type != null && type.getName().equals("XMLList")) {
            return E4XTypes.XML;
        }
        return null;
    }

    public static String getName(JSType type) {
        return type != null ? type.getName() : null;
    }

    public static String getName(IRType type) {
        return type != null ? type.getName() : null;
    }

    public static String getName(Type type) {
        if (type.isProxy()) {
            return URI.decode((String)((InternalEObject)type).eProxyURI().fragment());
        }
        return type.getName();
    }

    public static Type createProxy(String typeName) {
        return TypeUtil.createProxy(TypeUtil.createProxyURI(typeName));
    }

    public static Type createProxy(URI uri) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        type.setName(uri.fragment());
        ((InternalEObject)type).eSetProxyURI(uri);
        return type;
    }

    public static URI createProxyURI(String typeName) {
        if (typeName == null) {
            throw new NullPointerException("Type name is null");
        }
        return URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, (String)URI.encodeFragment((String)typeName, (boolean)false));
    }

    public static Type createProxy(Type type) {
        Type result = TypeInfoModelFactory.eINSTANCE.createType();
        if (type.isProxy()) {
            ((InternalEObject)result).eSetProxyURI(((InternalEObject)type).eProxyURI());
        } else {
            String typeName = type.getName();
            result.setName(typeName);
            ((InternalEObject)result).eSetProxyURI(TypeUtil.createProxyURI(typeName));
        }
        return result;
    }

    public static boolean isTypeProxy(URI uri) {
        return PROXY_SCHEME.equals(uri.scheme()) && PROXY_OPAQUE_PART.equals(uri.opaquePart());
    }

    public static URI createProxyResourceURI() {
        return URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, null);
    }

    public static EObject resolve(InternalEObject proxy, EObject objectContext) {
        if (proxy.eIsProxy()) {
            ResourceSet resourceSet;
            Resource resource = objectContext.eResource();
            if (resource != null && (resourceSet = resource.getResourceSet()) instanceof TypeInfoResourceSet) {
                return ((TypeInfoResourceSet)resourceSet).resolve(proxy, objectContext, resource);
            }
            return EcoreUtil.resolve((EObject)proxy, (EObject)objectContext);
        }
        return proxy;
    }

    public static boolean isDeclaringTypeVisible(Member member) {
        return member.getDeclaringType() != null && !(member.getDeclaringType().eContainer() instanceof RecordType);
    }

    public static boolean isValueTypeVisible(JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof UndefinedType) {
            return false;
        }
        return !(type instanceof RecordType);
    }

    public static TypeKind kind(IRType type) {
        if (type != null) {
            Type t;
            if (type instanceof IRSimpleType) {
                Type t2 = ((IRSimpleType)type).getTarget();
                if (t2 != null) {
                    return t2.getKind();
                }
            } else if (type instanceof IRClassType && (t = ((IRClassType)type).getTarget()) != null) {
                return t.getKind();
            }
        }
        return null;
    }

    public static List<Constructor> findConstructors(Type type) {
        HashSet<Type> types = new HashSet<Type>();
        while (types.add(type)) {
            EList<Constructor> constructors = type.getConstructors();
            if (!constructors.isEmpty()) {
                return constructors;
            }
            if (!type.isInheritConstructors() || (type = type.getSuperType()) == null) break;
        }
        return Collections.emptyList();
    }

    public static List<IRConstructor> findConstructors(IRTypeDeclaration type) {
        HashSet<IRTypeDeclaration> types = new HashSet<IRTypeDeclaration>();
        while (types.add(type)) {
            List<IRConstructor> constructors = type.getConstructors();
            if (!constructors.isEmpty()) {
                return constructors;
            }
            if (!type.getSource().isInheritConstructors() || (type = type.getSuperType()) == null) break;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static JSType createRType(IRType type) {
        if (type == null) {
            return null;
        }
        RType result = TypeInfoModelFactory.eINSTANCE.createRType();
        result.setRuntimeType(type);
        return result;
    }

    @NonNull
    public static TypeVariableReference reference(@NonNull TypeVariable variable) {
        TypeVariableReference reference = TypeInfoModelFactory.eINSTANCE.createTypeVariableReference();
        reference.setVariable(variable);
        return reference;
    }

    public static boolean containsTypeVariables(JSType type) {
        if (type != null) {
            Boolean result = TypeInferencerVisitor.GENERIC_TYPE_EXPRESSION.doSwitch(type);
            return result != null && result != false;
        }
        return false;
    }
}

