/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.List;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;

public class RMethodFunctionWrapper
implements IRMethod {
    private final IRFunctionType functionType;
    private final Object source;

    public RMethodFunctionWrapper(IRFunctionType functionType, IValueReference reference) {
        this.functionType = functionType;
        IModelBuilder.IMethod method = (IModelBuilder.IMethod)reference.getAttribute("METHOD", true);
        this.source = method != null ? method : reference.getAttribute("ELEMENT", true);
    }

    @Override
    public boolean isDeprecated() {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).isDeprecated();
        }
        if (this.source instanceof IModelBuilder.IMember) {
            return ((IModelBuilder.IMember)this.source).isDeprecated();
        }
        return false;
    }

    @Override
    public Visibility getVisibility() {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).getVisibility();
        }
        if (this.source instanceof IModelBuilder.IMember) {
            return ((IModelBuilder.IMember)this.source).getVisibility();
        }
        return Visibility.PUBLIC;
    }

    @Override
    public String getName() {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).getName();
        }
        if (this.source instanceof IModelBuilder.IMember) {
            return ((IModelBuilder.IMember)this.source).getName();
        }
        return null;
    }

    @Override
    public IRType getType() {
        return this.functionType.getReturnType();
    }

    @Override
    public Set<IProblemCategory> getSuppressedWarnings() {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).getSuppressedWarnings();
        }
        if (this.source instanceof IModelBuilder.IMember) {
            return ((IModelBuilder.IMember)this.source).getSuppressedWarnings();
        }
        return null;
    }

    @Override
    public boolean isSuppressed(IProblemIdentifier problemIdentifier) {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).isSuppressed(problemIdentifier);
        }
        return false;
    }

    @Override
    public int getParameterCount() {
        return this.functionType.getParameters().size();
    }

    @Override
    public List<IRParameter> getParameters() {
        return this.functionType.getParameters();
    }

    @Override
    public boolean isTyped() {
        if (this.functionType.getReturnType() != null) {
            return true;
        }
        List<IRParameter> params = this.functionType.getParameters();
        return params.size() != 1 || !RMethodFunctionWrapper.isVarArgAny(params.get(0));
    }

    private static boolean isVarArgAny(IRParameter parameter) {
        return parameter.getKind() == ParameterKind.VARARGS && parameter.getType() == RTypes.any();
    }

    @Override
    public Object getSource() {
        return this.functionType;
    }

    @Override
    public IRTypeDeclaration getDeclaringType() {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).getDeclaringType();
        }
        return null;
    }

    @Override
    public boolean isStatic() {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).isStatic();
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        if (this.source instanceof IRMethod) {
            return ((IRMethod)this.source).isAbstract();
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        if (this.source instanceof IRMember) {
            return ((IRMember)this.source).isVisible();
        }
        return true;
    }

    @Override
    public boolean isGeneric() {
        if (this.source instanceof IRMethod) {
            return ((IRMethod)this.source).isGeneric();
        }
        return false;
    }
}

