/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TopValueCollection;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IFunctionValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceHandler;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceHandlerFactory;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceListener;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferencerVisitor;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;

public abstract class TypeInferencerVisitorBase
extends ASTVisitor<IValueReference>
implements ITypeInferencerVisitor {
    protected final ITypeInferenceContext context;
    private Stack<IValueCollection> contexts = new Stack();
    @Nullable
    private ITypeInferenceHandler[] handlers = null;
    @Nullable
    ITypeInferenceListener[] listeners = null;
    protected JSProblemReporter reporter;
    protected ITypeChecker typeChecker;

    @Override
    public ITypeInferenceContext getContext() {
        return this.context;
    }

    @Override
    public IValueCollection peekContext() {
        return !this.contexts.isEmpty() ? this.contexts.peek() : null;
    }

    @Override
    public void enterContext(IValueCollection collection) {
        this.contexts.push(collection);
    }

    @Override
    public IValueCollection leaveContext() {
        return this.contexts.pop();
    }

    protected boolean inFunction() {
        return this.inFunction(false);
    }

    protected boolean inFunction(boolean ignoreBlocks) {
        int i = this.contexts.size();
        while (--i >= 0) {
            IValueCollection collection = (IValueCollection)this.contexts.get(i);
            if (!(collection instanceof IFunctionValueCollection) || ignoreBlocks && ((IFunctionValueCollection)collection).isInlineBlock()) continue;
            return true;
        }
        return false;
    }

    public TypeInferencerVisitorBase(ITypeInferenceContext context) {
        this.context = context;
    }

    public void initialize() {
        this.contexts.clear();
        this.contexts.push(new TopValueCollection(this.context));
        this.listeners = null;
        List<ITypeInferenceHandler> handlers = this.createHandlers();
        this.handlers = handlers != null && !handlers.isEmpty() ? handlers.toArray(new ITypeInferenceHandler[handlers.size()]) : null;
    }

    protected List<ITypeInferenceHandler> createHandlers() {
        ArrayList<ITypeInferenceHandler> handlers = new ArrayList<ITypeInferenceHandler>();
        ITypeInferenceHandlerFactory[] iTypeInferenceHandlerFactoryArray = TypeInfoManager.getNodeHandlerFactories();
        int n = iTypeInferenceHandlerFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeInferenceHandlerFactory factory = iTypeInferenceHandlerFactoryArray[n2];
            ITypeInferenceHandler handler = factory.create(this.context, this);
            if (handler != null) {
                handlers.add(handler);
            }
            ++n2;
        }
        return handlers;
    }

    @Override
    public void addListener(ITypeInferenceListener listener) {
        assert (listener != null);
        if (this.listeners == null) {
            this.listeners = new ITypeInferenceListener[]{listener};
        } else {
            int length = this.listeners.length;
            int i = 0;
            while (i < length) {
                if (listener.equals(this.listeners[i])) {
                    return;
                }
                ++i;
            }
            this.listeners = new ITypeInferenceListener[length + 1];
            System.arraycopy(this.listeners, 0, this.listeners, 0, length);
            this.listeners[length] = listener;
        }
    }

    public IValueReference visit(ASTNode node) {
        if (this.handlers != null) {
            ITypeInferenceHandler[] iTypeInferenceHandlerArray = this.handlers;
            int n = this.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeInferenceHandler handler = iTypeInferenceHandlerArray[n2];
                IValueReference result = handler.handle(node);
                if (result != ITypeInferenceHandler.CONTINUE) {
                    return result;
                }
                ++n2;
            }
        }
        try {
            return (IValueReference)super.visit(node);
        }
        catch (PositionReachedException e) {
            throw e;
        }
        catch (TIWrappedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            JavaScriptPlugin.error(this.buildNodeErrorMessage(node), e);
            throw new TIWrappedException(e);
        }
        catch (AssertionError e) {
            JavaScriptPlugin.error(this.buildNodeErrorMessage(node), (Throwable)((Object)e));
            throw new TIWrappedException((Throwable)((Object)e));
        }
    }

    protected String buildNodeErrorMessage(ASTNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error processing ");
        sb.append(node.getClass().getName());
        try {
            String message = node.toString();
            sb.append(" \"").append(message).append("\"");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sb.append(" in ").append(this.context.getSource());
        return sb.toString();
    }

    public void done() {
        IValue value;
        IValueCollection collection = this.getCollection();
        if (collection instanceof ValueCollection && (value = ((ValueCollection)collection).getValue()) instanceof Value) {
            ((Value)value).resolveLazyValues(new HashSet<Value>());
        }
        if (this.listeners != null) {
            ITypeInferenceListener[] iTypeInferenceListenerArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeInferenceListener listener = iTypeInferenceListenerArray[n2];
                listener.done();
                ++n2;
            }
        }
    }

    public IValueCollection getCollection() {
        return (IValueCollection)this.contexts.get(0);
    }

    protected IValueReference merge(IValueReference value1, IValueReference value2) {
        AnonymousValue reference = new AnonymousValue();
        reference.setValue(value1);
        reference.addValue(value2, false);
        return reference;
    }

    @Override
    public JSProblemReporter getProblemReporter() {
        return this.reporter;
    }

    @Override
    public void suppressProblems(IProblemIdentifier ... identifiers) {
        if (this.reporter != null) {
            ((Reporter)this.reporter).suppressProblems(identifiers);
        }
    }

    @Nullable
    public ITypeChecker getTypeChecker() {
        return this.typeChecker;
    }

    static class TIWrappedException
    extends RuntimeException {
        public TIWrappedException(Throwable cause) {
            super(cause);
        }
    }
}

