/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

public class DelegatingTaskReporter
implements ITaskReporter {
    private final ITaskReporter taskReporter;
    private final ISourceLineTracker lineTracker;
    private int lineOffset = 0;
    private int locationOffset = 0;

    public DelegatingTaskReporter(ITaskReporter taskReporter, ISourceLineTracker lineTracker) {
        this.taskReporter = taskReporter;
        this.lineTracker = lineTracker;
    }

    @Override
    public void reportTask(String message, int lineNumber, int priority, int charStart, int charEnd) {
        this.taskReporter.reportTask(message, lineNumber + this.lineOffset, priority, charStart + this.locationOffset, charEnd + this.locationOffset);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void setOffset(int offset) {
        this.locationOffset = offset;
        this.lineOffset = this.lineTracker.getLineNumberOfOffset(offset);
    }
}

