/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map<ITextEditor, PartListenerGroup> fListenerGroups = new HashMap<ITextEditor, PartListenerGroup>();

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener == null) {
                partListener = new PartListenerGroup(part);
                this.fListenerGroups.put(part, partListener);
            }
            partListener.install(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener != null) {
                partListener.uninstall(listener);
                if (partListener.isEmpty()) {
                    partListener.cancelJob();
                    this.fListenerGroups.remove(part);
                }
            }
        }
    }

    protected static class ASTJob
    extends Job {
        private final PartListenerGroup owner;
        private final ISourceModule input;
        private final ITextSelection selection;
        private boolean wasCancel;

        public ASTJob(PartListenerGroup owner, ISourceModule module, ITextSelection selection) {
            super(DLTKUIMessages.SelectionListenerWithASTManager_job_title);
            this.owner = owner;
            this.input = module;
            this.selection = selection;
            this.setPriority(50);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            ASTJob aSTJob = this;
            synchronized (aSTJob) {
                this.wasCancel = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            block9: {
                try {
                    if (this.input.isConsistent()) break block9;
                    ASTJob aSTJob = this;
                    synchronized (aSTJob) {
                        if (!this.wasCancel) {
                            this.schedule(1000L);
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
            Object object = this.owner.fJobLock;
            synchronized (object) {
                return this.calculateASTandInform(monitor);
            }
        }

        protected final IStatus calculateASTandInform(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                IModuleDeclaration astRoot = SourceParserUtil.parse((ISourceModule)this.input, null);
                if (astRoot != null && !monitor.isCanceled()) {
                    Object[] listeners = this.owner.fAstListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((ISelectionListenerWithAST)listeners[i]).selectionChanged((IEditorPart)this.owner.fPart, this.selection, this.input, astRoot);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
            return Status.CANCEL_STATUS;
        }
    }

    private static final class PartListenerGroup {
        protected final ITextEditor fPart;
        private ISelectionListener fPostSelectionListener;
        private ISelectionChangedListener fSelectionListener;
        private Job fCurrentJob;
        protected final ListenerList fAstListeners;
        protected final Object fJobLock = new Object();

        public PartListenerGroup(ITextEditor editorPart) {
            this.fPart = editorPart;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList(1);
            this.fSelectionListener = event -> {
                ISelection selection = event.getSelection();
                if (selection instanceof ITextSelection) {
                    this.fireSelectionChanged((ITextSelection)selection);
                }
            };
            this.fPostSelectionListener = (part, selection) -> {
                if (part == this.fPart && selection instanceof ITextSelection) {
                    this.firePostSelectionChanged((ITextSelection)selection);
                }
            };
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST listener) {
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().addPostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.addSelectionChangedListener(this.fSelectionListener);
                }
            }
            this.fAstListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithAST listener) {
            this.fAstListeners.remove((Object)listener);
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().removePostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
                }
            }
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(ITextSelection selection) {
            this.cancelJob();
            ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fPart, false);
            if (!(input instanceof ISourceModule)) {
                return;
            }
            this.fCurrentJob = new ASTJob(this, input, selection);
            this.fCurrentJob.schedule();
        }

        void cancelJob() {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
                this.fCurrentJob = null;
            }
        }
    }
}

