/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.structure.ParentNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

public class FieldNode
extends ParentNode
implements IDeclaration {
    private final Expression node;
    private final String name;
    private final ReferenceLocation location;
    private IStructureNode value;

    public FieldNode(IParentNode parent, Expression node, String name, ReferenceLocation location) {
        super(parent);
        this.node = node;
        this.name = name;
        this.location = location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JSType getType() {
        return null;
    }

    @Override
    public ReferenceLocation getLocation() {
        return this.location;
    }

    @Override
    public int start() {
        return this.getLocation().getDeclarationStart();
    }

    public IStructureNode getValue() {
        return this.value;
    }

    public void setValue(IStructureNode value) {
        this.value = value;
    }

    public List<IStructureNode> getChildren() {
        return this.value != null ? Collections.singletonList(this.value) : Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("this.");
        sb.append(this.getName());
        sb.append(":field");
        if (this.value != null) {
            sb.append("=");
            sb.append(this.value);
        }
        return sb.toString();
    }

    @Override
    public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
        IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
        info.declarationStart = this.location.getDeclarationStart();
        info.name = this.getName();
        info.nameSourceStart = this.location.getNameStart();
        info.nameSourceEnd = this.location.getNameEnd() - 1;
        requestor.enterField(info, this.node, null, true);
        this.reportChildrenStructure(requestor, context);
        requestor.exitField(this.location.getDeclarationEnd() - 1);
    }
}

