/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveEntryFile;
import org.eclipse.dltk.internal.core.ArchiveFolderInfo;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.util.Util;

public class ArchiveFolder
extends ScriptFolder {
    public ArchiveFolder(ProjectFragment parent, IPath path) {
        super(parent, path);
    }

    void computeForeignResources(String[] resNames, ArchiveFolderInfo info, String zipName) {
        if (resNames == null) {
            info.setForeignResources(null);
            return;
        }
        int max = resNames.length;
        if (max == 0) {
            info.setForeignResources(ModelElementInfo.NO_NON_SCRIPT_RESOURCES);
        } else {
            Object[] res = new Object[max];
            int index = 0;
            int i = 0;
            while (i < max) {
                String resName = resNames[i];
                if (!Util.isValidSourceModuleName(this.getScriptProject(), resName)) {
                    Path resPath = new Path(resName);
                    res[index++] = new ArchiveEntryFile(resPath.lastSegment(), zipName, this.path, this.getProjectFragment().getResource(), (ArchiveProjectFragment)this.parent);
                }
                ++i;
            }
            if (index != max) {
                Object[] objectArray = res;
                res = new Object[index];
                System.arraycopy(objectArray, 0, res, 0, index);
            }
            info.setForeignResources(res);
        }
    }

    @Override
    public ISourceModule getSourceModule(String name) {
        ArchiveProjectFragment fragment = (ArchiveProjectFragment)this.getProjectFragment();
        return new ExternalSourceModule(this, name, DefaultWorkingCopyOwner.PRIMARY, new ArchiveEntryFile(name, fragment.getZipName(), this.path, fragment.getResource(), (ArchiveProjectFragment)this.parent));
    }

    protected boolean computeChildren(OpenableElementInfo info, ArrayList entryNames) {
        if (entryNames != null && entryNames.size() > 0) {
            ArrayList<ISourceModule> vChildren = new ArrayList<ISourceModule>();
            for (String child : entryNames) {
                ISourceModule classFile = this.getSourceModule(child);
                vChildren.add(classFile);
            }
            IModelElement[] children = new IModelElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(NO_ELEMENTS);
        }
        return true;
    }

    @Override
    public ISourceModule[] getSourceModules() throws ModelException {
        List<IModelElement> list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    @Override
    protected Object createElementInfo() {
        return null;
    }

    @Override
    public Object[] getForeignResources() throws ModelException {
        return ((ArchiveFolderInfo)this.getElementInfo()).getForeignResources();
    }
}

