/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureContext;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureReporter3;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureRequestor;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;

public class JavaScriptSourceElementParser3
implements ISourceElementParser {
    protected ISourceElementRequestor fRequestor = null;
    protected IProblemReporter fReporter = null;

    public void setRequestor(ISourceElementRequestor requestor) {
        this.fRequestor = requestor;
    }

    public void setReporter(IProblemReporter reporter) {
        this.fReporter = reporter;
    }

    public void parseSourceModule(IModuleSource module) {
        Script script = this.parse(module);
        StructureReporter3 reporter = new StructureReporter3(ReferenceSource.create(module.getModelElement()));
        IStructureNode node = reporter.visit((ASTNode)script);
        this.reportStructure(script, node);
    }

    protected void reportStructure(Script script, IStructureNode node) {
        this.fRequestor.enterModule();
        node.reportStructure(new StructureRequestor(this.fRequestor), new StructureContext());
        this.fRequestor.exitModule(script.sourceEnd());
    }

    protected Script parse(IModuleSource module) {
        return JavaScriptParserUtil.parse((IModuleSource)module, (IProblemReporter)this.fReporter);
    }
}

