/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.statements;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class UntilStatement
extends Statement {
    private Statement fCondition;
    private Statement fAction;

    public UntilStatement(DLTKToken token) {
        super(token);
    }

    public UntilStatement(DLTKToken whileToken, Expression condition, Statement action) {
        this.setStart(whileToken.getColumn());
        this.fCondition = condition;
        this.fAction = action;
    }

    public UntilStatement(Statement condition, Statement action) {
        this.fCondition = condition;
        this.fAction = action;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.fCondition != null) {
                this.fCondition.traverse(pVisitor);
            }
            if (this.fAction != null) {
                this.fAction.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 2017;
    }

    public Statement getCondition() {
        return this.fCondition;
    }

    public Statement getAction() {
        return this.fAction;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("while");
        if (this.fCondition != null) {
            this.fCondition.printNode(output);
        }
        if (this.fAction != null) {
            output.indent();
            this.fAction.printNode(output);
            output.dedent();
        }
        output.formatPrint("");
    }
}

