/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Visibility implements Enumerator
{
    PUBLIC(0, "PUBLIC", "PUBLIC"),
    PROTECTED(50, "PROTECTED", "PROTECTED"),
    INTERNAL(75, "INTERNAL", "INTERNAL"),
    PRIVATE(100, "PRIVATE", "PRIVATE");

    public static final int PUBLIC_VALUE = 0;
    public static final int PROTECTED_VALUE = 50;
    public static final int INTERNAL_VALUE = 75;
    public static final int PRIVATE_VALUE = 100;
    private static final Visibility[] VALUES_ARRAY;
    public static final List<Visibility> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Visibility[]{PUBLIC, PROTECTED, INTERNAL, PRIVATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Visibility get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Visibility result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Visibility getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Visibility result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Visibility get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 50: {
                return PROTECTED;
            }
            case 75: {
                return INTERNAL;
            }
            case 100: {
                return PRIVATE;
            }
        }
        return null;
    }

    private Visibility(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public int getFlags() {
        switch (this) {
            case PUBLIC: {
                return 64;
            }
            case PROTECTED: {
                return 32;
            }
            case PRIVATE: {
                return 16;
            }
        }
        return 0;
    }

    public static int getFlags(Visibility visibility) {
        return visibility != null ? visibility.getFlags() : 0;
    }
}

