/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.nio.charset.StandardCharsets;
import org.eclipse.dltk.rhino.dbgp.Base64;

public class Base64Helper {
    private static final String EMPTY = "";

    public static String encodeString(String s) {
        if (s != null && s.length() != 0) {
            byte[] encode = Base64.encode(s.getBytes(StandardCharsets.UTF_8));
            return new String(encode, StandardCharsets.ISO_8859_1);
        }
        return EMPTY;
    }

    public static String decodeString(String base64) {
        byte[] bytes;
        int length;
        if (base64 != null && base64.length() != 0 && (length = Base64Helper.discardWhitespace(bytes = base64.getBytes(StandardCharsets.ISO_8859_1))) > 0) {
            int decodedLength = Base64.decodeInlplace(bytes, length);
            return new String(bytes, 0, decodedLength, StandardCharsets.UTF_8);
        }
        return EMPTY;
    }

    private static int discardWhitespace(byte[] data) {
        int length = data.length;
        int i = 0;
        while (i < length) {
            byte c;
            if ((c = data[i++]) != 32 && c != 10 && c != 13 && c != 9) continue;
            int count = i - 1;
            while (i < length) {
                if ((c = data[i++]) == 32 || c == 10 || c == 13 || c == 9) continue;
                data[count++] = c;
            }
            return count;
        }
        return length;
    }

    public static String encodeBytes(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public static byte[] decodeBytes(String base64) {
        return Base64.decode(base64.getBytes());
    }
}

