/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.manipulation.RefactoringChecks;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.javascript.core.manipulation.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.Checks;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.ExtractMethodAnalyzer;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.VariableBinding;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.Selection;
import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BinaryOperator;
import org.eclipse.dltk.javascript.core.dom.BlockStatement;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.DomFactory;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ExpressionStatement;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Parameter;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.VariableStatement;
import org.eclipse.dltk.javascript.core.dom.rewrite.ASTConverter;
import org.eclipse.dltk.javascript.core.dom.rewrite.Generator;
import org.eclipse.dltk.javascript.core.dom.rewrite.RewriteAnalyzer;
import org.eclipse.dltk.javascript.core.dom.rewrite.VariableLookup;
import org.eclipse.dltk.javascript.core.refactoring.descriptors.ExtractMethodDescriptor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class ExtractMethodRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private ISourceModule fCUnit;
    private String fSource;
    private Source fRoot;
    private int fSelectionStart;
    private int fSelectionLength;
    private ExtractMethodAnalyzer fAnalyzer;
    private String fMethodName;
    private List<ParameterInfo> fParameterInfos;
    private Set<String> fUsedNames;
    private int fDestinationIndex = 0;
    private Node fDestination;
    private Node[] fDestinations;
    private static final String EMPTY = "";

    public ExtractMethodRefactoring(ISourceModule unit, int selectionStart, int selectionLength) {
        this.fCUnit = unit;
        this.fRoot = null;
        this.fMethodName = "extracted";
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractMethodRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(EMPTY, 100);
        if (this.fSelectionStart < 0 || this.fSelectionLength == 0) {
            result.addFatalError(RefactoringCoreMessages.ExtractMethodRefactoring_no_set_of_statements);
            return result;
        }
        IFile[] changedFiles = ResourceUtil.getFiles((ISourceModule[])new ISourceModule[]{this.fCUnit});
        result.merge(RefactoringChecks.validateModifiesFiles((IFile[])changedFiles, (Object)this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])changedFiles, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        if (this.fRoot == null) {
            this.fRoot = (Source)ASTConverter.convert((ASTNode)JavaScriptParserUtil.parse((ISourceModule)this.fCUnit));
        }
        this.fAnalyzer = new ExtractMethodAnalyzer(this.fCUnit, Selection.createFromStartLength(this.fSelectionStart, this.fSelectionLength));
        result.merge(this.fAnalyzer.checkInitialConditions(this.fRoot));
        if (result.hasFatalError()) {
            return result;
        }
        this.fSource = this.fCUnit.getSource();
        Node[] nodes = this.fAnalyzer.getSelectedNodes();
        boolean badSelection = false;
        int i = this.fSelectionStart;
        while (i < nodes[0].getBegin()) {
            if (!Character.isWhitespace(this.fSource.charAt(i))) {
                badSelection = true;
            }
            ++i;
        }
        i = nodes[nodes.length - 1].getEnd();
        while (i < this.fSelectionStart + this.fSelectionLength) {
            if (!Character.isWhitespace(this.fSource.charAt(i))) {
                badSelection = true;
            }
            ++i;
        }
        if (badSelection) {
            result.addFatalError(RefactoringCoreMessages.StatementAnalyzer_doesNotCover);
            return result;
        }
        this.initializeParameterInfos();
        this.initializeUsedNames();
        this.initializeDestinations();
        return result;
    }

    public void setMethodName(String name) {
        this.fMethodName = name;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.fParameterInfos;
    }

    public RefactoringStatus checkMethodName() {
        return Checks.validateIdentifier(this.fMethodName);
    }

    public Node[] getDestinations() {
        return this.fDestinations;
    }

    public void setDestination(int index) {
        this.fDestination = this.fDestinations[index];
        this.fDestinationIndex = index;
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        for (ParameterInfo parameter : this.fParameterInfos) {
            result.merge(Checks.validateIdentifier(parameter.getNewName()));
            for (ParameterInfo other : this.fParameterInfos) {
                if (parameter == other || !other.getNewName().equals(parameter.getNewName())) continue;
                result.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_sameParameter, other.getNewName()));
                return result;
            }
            if (!parameter.isRenamed() || !this.fUsedNames.contains(parameter.getNewName())) continue;
            result.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_nameInUse, parameter.getNewName()));
            return result;
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ExtractMethodRefactoring_checking_new_name, 1);
        pm.subTask(EMPTY);
        RefactoringStatus result = this.checkMethodName();
        result.merge(this.checkParameterNames());
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fMethodName == null) {
            return null;
        }
        pm.beginTask(EMPTY, 2);
        try {
            Object local;
            ChangeRecorder cr = new ChangeRecorder((EObject)this.fRoot);
            Node[] nodes = this.fAnalyzer.getSelectedNodes();
            boolean isExpr = this.fAnalyzer.isExpressionSelected();
            HashMap<String, String> renamings = new HashMap<String, String>();
            for (ParameterInfo parameter : this.fParameterInfos) {
                if (!parameter.isRenamed()) continue;
                renamings.put(parameter.getOldName(), parameter.getNewName());
            }
            Node[] nodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                List<Identifier> oldNames = VariableLookup.findReferences(node, renamings.keySet());
                for (Identifier ref : oldNames) {
                    ref.setName((String)renamings.get(ref.getName()));
                }
                ++n2;
            }
            CallExpression invocation = DomFactory.eINSTANCE.createCallExpression();
            VariableReference ref = DomFactory.eINSTANCE.createVariableReference();
            Identifier id = DomFactory.eINSTANCE.createIdentifier();
            id.setName(this.fMethodName);
            ref.setVariable(id);
            invocation.setApplicant(ref);
            for (ParameterInfo parameter : this.fParameterInfos) {
                Identifier name = DomFactory.eINSTANCE.createIdentifier();
                name.setName(parameter.getOldName());
                local = DomFactory.eINSTANCE.createVariableReference();
                local.setVariable(name);
                invocation.getArguments().add(local);
            }
            if (isExpr) {
                ref = nodes[0].eContainmentFeature();
                if (ref.isMany()) {
                    EList exprList = (EList)nodes[0].eContainer().eGet((EStructuralFeature)ref);
                    exprList.set(exprList.lastIndexOf((Object)nodes[0]), (Object)invocation);
                } else {
                    nodes[0].eContainer().eSet((EStructuralFeature)ref, (Object)invocation);
                }
            } else {
                Node call;
                int returnKind = this.fAnalyzer.getReturnKind();
                switch (returnKind) {
                    case 2: {
                        VariableBinding binding = this.fAnalyzer.getReturnLocal();
                        if (binding != null) {
                            call = this.createDeclaration(binding, invocation);
                            break;
                        }
                        BinaryExpression assignment = DomFactory.eINSTANCE.createBinaryExpression();
                        assignment.setOperation(BinaryOperator.ASSIGN);
                        VariableReference retVar = DomFactory.eINSTANCE.createVariableReference();
                        Identifier id2 = DomFactory.eINSTANCE.createIdentifier();
                        id2.setName(this.fAnalyzer.getReturnValue().getName());
                        retVar.setVariable(id2);
                        assignment.setLeft(retVar);
                        assignment.setRight(invocation);
                        call = assignment;
                        break;
                    }
                    case 4: {
                        ReturnStatement rs = DomFactory.eINSTANCE.createReturnStatement();
                        rs.setExpression(invocation);
                        call = rs;
                        break;
                    }
                    default: {
                        call = invocation;
                    }
                }
                if (call instanceof Expression) {
                    ExpressionStatement stmt = DomFactory.eINSTANCE.createExpressionStatement();
                    stmt.setExpression((Expression)call);
                    call = stmt;
                }
                ArrayList<Statement> callNodes = new ArrayList<Statement>(2);
                callNodes.add((Statement)call);
                if (returnKind == 3 && !this.fAnalyzer.isLastStatementSelected()) {
                    callNodes.add(DomFactory.eINSTANCE.createReturnStatement());
                }
                VariableBinding[] variableBindingArray = this.fAnalyzer.getCallerLocals();
                int id2 = variableBindingArray.length;
                int retVar = 0;
                while (retVar < id2) {
                    local = variableBindingArray[retVar];
                    callNodes.add(this.createDeclaration((VariableBinding)local, null));
                    ++retVar;
                }
                EReference ref2 = nodes[0].eContainmentFeature();
                if (ref2.isMany()) {
                    EList list = (EList)nodes[0].eContainer().eGet((EStructuralFeature)ref2);
                    int index = list.lastIndexOf((Object)nodes[0]);
                    int i2 = nodes.length - 1;
                    while (i2 >= 0) {
                        list.remove(index + i2);
                        --i2;
                    }
                    list.addAll(index, callNodes);
                } else if (callNodes.size() == 1) {
                    nodes[0].eContainer().eSet((EStructuralFeature)ref2, callNodes.get(0));
                } else {
                    BlockStatement block = DomFactory.eINSTANCE.createBlockStatement();
                    block.getStatements().addAll(callNodes);
                    nodes[0].eContainer().eSet((EStructuralFeature)ref2, (Object)block);
                }
            }
            FunctionExpression mm = this.createNewMethodDeclaration();
            EList<Statement> statements = mm.getBody().getStatements();
            VariableBinding[] methodLocals = this.fAnalyzer.getMethodLocals();
            int i = 0;
            while (i < methodLocals.length) {
                if (methodLocals[i] != null) {
                    statements.add(this.createDeclaration(methodLocals[i], null));
                }
                ++i;
            }
            if (isExpr) {
                ReturnStatement rs = DomFactory.eINSTANCE.createReturnStatement();
                rs.setExpression((Expression)nodes[0]);
                statements.add(rs);
            } else {
                Node[] i2 = nodes;
                int index = nodes.length;
                int block = 0;
                while (block < index) {
                    Node node = i2[block];
                    statements.add((Statement)node);
                    ++block;
                }
                VariableBinding returnValue = this.fAnalyzer.getReturnValue();
                if (returnValue != null) {
                    ReturnStatement rs = DomFactory.eINSTANCE.createReturnStatement();
                    VariableReference ret = DomFactory.eINSTANCE.createVariableReference();
                    Identifier rid = DomFactory.eINSTANCE.createIdentifier();
                    String name = returnValue.getName();
                    if (renamings.containsKey(name)) {
                        name = (String)renamings.get(name);
                    }
                    rid.setName(name);
                    ret.setVariable(rid);
                    rs.setExpression(ret);
                    statements.add(rs);
                }
            }
            final ExpressionStatement stmt = DomFactory.eINSTANCE.createExpressionStatement();
            stmt.setExpression(mm);
            Node enclosing = this.fDestination;
            EReference ref3 = enclosing.eContainmentFeature();
            assert (ref3.isMany());
            EList list = (EList)enclosing.eContainer().eGet((EStructuralFeature)ref3);
            list.add(list.lastIndexOf((Object)enclosing) + 1, (Object)stmt);
            ChangeDescription cd = cr.endRecording();
            RewriteAnalyzer ra = new RewriteAnalyzer(cd, this.fSource){

                @Override
                protected void addEdit(TextEdit edit, Node node) {
                    if (node == stmt) {
                        edit = new InsertEdit(edit.getOffset(), String.valueOf(this.lineDelimiter) + ((InsertEdit)edit).getText());
                    }
                    super.addEdit(edit, node);
                }
            };
            SourceModuleChange result = new SourceModuleChange(RefactoringCoreMessages.ExtractMethodRefactoring_change_name, this.fCUnit);
            ra.rewrite(this.fRoot);
            result.setSaveMode(1);
            result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.getRefactoringDescriptor()));
            result.setEdit(ra.getEdit());
            cd.apply();
            SourceModuleChange sourceModuleChange = result;
            return sourceModuleChange;
        }
        finally {
            pm.done();
        }
    }

    private ExtractMethodDescriptor getRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IScriptProject ScriptProject = this.fCUnit.getScriptProject();
        if (ScriptProject != null) {
            project = ScriptProject.getElementName();
        }
        int flags = 589826;
        String description = Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_descriptor_description_short, this.fMethodName);
        ExtractMethodDescriptor descriptor = new ExtractMethodDescriptor(project, description, EMPTY, arguments, 589826);
        arguments.put("input", ScriptRefactoringDescriptor.elementToHandle((String)project, (IModelElement)this.fCUnit));
        arguments.put("name", this.fMethodName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_DESTINATION, new Integer(this.fDestinationIndex).toString());
        return descriptor;
    }

    public String getSignature() {
        return this.getSignature(this.fMethodName);
    }

    public String getSignature(String methodName) {
        FunctionExpression methodDecl = this.createNewMethodDeclaration();
        String str = new Generator(null, EMPTY, 0, EMPTY).generate(methodDecl).toString();
        return str.substring(0, str.indexOf(123) - 1);
    }

    private void initializeParameterInfos() {
        VariableBinding[] arguments = this.fAnalyzer.getArguments();
        this.fParameterInfos = new ArrayList<ParameterInfo>(arguments.length);
        int i = 0;
        while (i < arguments.length) {
            String argument = arguments[i].getName();
            String type = arguments[i].getTypeName();
            if (type == null) {
                type = EMPTY;
            }
            this.fParameterInfos.add(new ParameterInfo(type, argument, i));
            ++i;
        }
    }

    private void initializeUsedNames() {
        this.fUsedNames = VariableLookup.getVisibleNames(this.fAnalyzer.getSelectedNodes()[0]);
        for (ParameterInfo parameter : this.fParameterInfos) {
            this.fUsedNames.remove(parameter.getOldName());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeDestinations() {
        block6: {
            result = new ArrayList<Node>();
            node = this.fAnalyzer.getEnclosingNode();
            parent = node == null ? null : (Node)node.eContainer();
            v0 = grandparent = parent == null ? null : (Node)parent.eContainer();
            if (!(node instanceof Source)) ** GOTO lbl22
            cur = this.fAnalyzer.getSelectedNodes()[0];
            while (cur.eContainer() != node) {
                cur = (Node)cur.eContainer();
            }
            result.add(cur);
            break block6;
            while (!(parent instanceof Source)) {
                stop = false;
                switch (grandparent.eClass().getClassifierID()) {
                    case 20: 
                    case 21: 
                    case 56: {
                        stop = true;
                    }
                }
                if (stop) break;
                node = parent;
                parent = grandparent;
                v1 = grandparent = parent == null ? null : (Node)parent.eContainer();
lbl22:
                // 2 sources

                if (node != null) continue;
            }
            if (node != null) {
                result.add(node);
            }
        }
        this.fDestinations = result.toArray(new Node[result.size()]);
        this.fDestination = this.fDestinations[this.fDestinationIndex];
    }

    private FunctionExpression createNewMethodDeclaration() {
        FunctionExpression result = DomFactory.eINSTANCE.createFunctionExpression();
        this.fAnalyzer.getReturnTypeName();
        Identifier id = DomFactory.eINSTANCE.createIdentifier();
        id.setName(this.fMethodName);
        result.setIdentifier(id);
        EList<Parameter> parameters = result.getParameters();
        int i = 0;
        while (i < this.fParameterInfos.size()) {
            ParameterInfo info = this.fParameterInfos.get(i);
            Parameter parameter = DomFactory.eINSTANCE.createParameter();
            Identifier prmName = DomFactory.eINSTANCE.createIdentifier();
            prmName.setName(info.getNewName());
            parameter.setName(prmName);
            EMPTY.equals(info.getNewTypeName());
            parameters.add(parameter);
            ++i;
        }
        result.setBody(DomFactory.eINSTANCE.createBlockStatement());
        return result;
    }

    private VariableStatement createDeclaration(VariableBinding name, Expression initializer) {
        Identifier id = DomFactory.eINSTANCE.createIdentifier();
        id.setName(name.getName());
        VariableDeclaration decl = DomFactory.eINSTANCE.createVariableDeclaration();
        decl.setIdentifier(id);
        name.getTypeName();
        if (initializer != null) {
            decl.setInitializer(initializer);
        }
        VariableStatement result = DomFactory.eINSTANCE.createVariableStatement();
        result.getDeclarations().add((Object)decl);
        return result;
    }
}

