/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.dltk.javascript.typeinfo.IRAnyType;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRNoneType;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeFactory;
import org.eclipse.dltk.javascript.typeinfo.IRUndefinedType;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.OriginReference;
import org.eclipse.dltk.javascript.typeinfo.RModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeQuery;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.AnyType;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.RType;
import org.eclipse.dltk.javascript.typeinfo.model.RecordMember;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableClassType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableReference;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSTypeSet
implements Iterable<IRType> {
    private static final JSEmptyTypeSet EMPTY_SET = new JSEmptyTypeSet();
    private static final boolean DEBUG = false;
    private static final IRType ANY_TYPE = new AnyTypeKey();
    private static final IRType NONE_TYPE = new NoneTypeKey();
    private static final IRType UNDEFINED_TYPE = new UndefinedTypeKey();

    public static JSTypeSet emptySet() {
        return EMPTY_SET;
    }

    public static JSTypeSet singleton(IRType type) {
        if (type instanceof IRUnionType) {
            JSTypeSet set = JSTypeSet.create();
            set.add(type);
            return set;
        }
        return new JSSingletonTypeSet(type);
    }

    public static IRType normalize(JSType type) {
        return JSTypeSet.normalize(null, type);
    }

    public static IRType normalize(ITypeSystem context, JSType type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            Type target = parameterized.getTarget();
            if (target == null) {
                return JSTypeSet.any();
            }
            if (context != null) {
                EList<JSType> typeArguments = parameterized.getActualTypeArguments();
                ArrayList<IRType> parameters = new ArrayList<IRType>(typeArguments.size());
                int i = 0;
                while (i < typeArguments.size()) {
                    parameters.add(JSTypeSet.normalize(context, (JSType)typeArguments.get(i)));
                    ++i;
                }
                return new SimpleTypeKey(context, context.parameterize(target, parameters));
            }
            return JSTypeSet.ref(target);
        }
        if (type instanceof TypeVariableReference) {
            return JSTypeSet.none();
        }
        if (type instanceof TypeVariableClassType) {
            return JSTypeSet.classType(null);
        }
        if (type instanceof SimpleType) {
            SimpleType ref = (SimpleType)type;
            Type target = ref.getTarget();
            if (target == null) {
                return JSTypeSet.any();
            }
            if (target.isProxy() && context != null) {
                target = context.resolveType(target);
            }
            return JSTypeSet.ref(target);
        }
        if (type instanceof ClassType) {
            Type target = ((ClassType)type).getTarget();
            if (target != null && target.isProxy() && context != null) {
                target = context.resolveType(target);
            }
            return JSTypeSet.classType(target);
        }
        if (type instanceof ArrayType) {
            JSType itemType = ((ArrayType)type).getItemType();
            return new ArrayTypeKey(context, JSTypeSet.normalize(context, itemType));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return JSTypeSet.mapOf(JSTypeSet.normalize(context, mapType.getKeyType()), JSTypeSet.normalize(context, mapType.getValueType()));
        }
        if (type instanceof AnyType) {
            return ANY_TYPE;
        }
        if (type instanceof UndefinedType) {
            return UNDEFINED_TYPE;
        }
        if (type instanceof UnionType) {
            UnionTypeKey union = new UnionTypeKey();
            for (JSType t : ((UnionType)type).getTargets()) {
                union.targets.add(JSTypeSet.normalize(context, t));
            }
            return union;
        }
        if (type instanceof RecordType) {
            return new RecordTypeKey(context, (List<Member>)((RecordType)type).getMembers());
        }
        if (type instanceof FunctionType) {
            FunctionType funcType = (FunctionType)type;
            return new FunctionTypeKey(RModelBuilder.convert(context, funcType.getParameters()), JSTypeSet.normalize(context, funcType.getReturnType()));
        }
        if (type instanceof RType) {
            return ((RType)type).getRuntimeType();
        }
        if (type == null) {
            return null;
        }
        IRTypeFactory[] iRTypeFactoryArray = TypeInfoManager.getRTypeFactories();
        int n = iRTypeFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRTypeFactory factory = iRTypeFactoryArray[n2];
            IRType runtimeType = factory.create(context, type);
            if (runtimeType != null) {
                return runtimeType;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    public static IRType ref(Type type) {
        IRTypeFactory[] iRTypeFactoryArray = TypeInfoManager.getRTypeFactories();
        int n = iRTypeFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRTypeFactory factory = iRTypeFactoryArray[n2];
            IRType runtimeType = factory.create(type);
            if (runtimeType != null) {
                return runtimeType;
            }
            ++n2;
        }
        if ("Array".equals(type.getName())) {
            return JSTypeSet.arrayOf(JSTypeSet.none());
        }
        return new SimpleTypeKey(type);
    }

    public static IRType ref(String name) {
        Type type = TypeInfoModelLoader.getInstance().getType(name);
        return JSTypeSet.ref(type);
    }

    public static IRClassType classType(Type type) {
        return new ClassTypeKey(type);
    }

    public static ArrayTypeKey arrayOf(IRType itemType) {
        return new ArrayTypeKey(itemType);
    }

    public static MapTypeKey mapOf(IRType keyType, IRType valueType) {
        return new MapTypeKey(keyType, valueType);
    }

    public static IRType any() {
        return ANY_TYPE;
    }

    public static IRType none() {
        return NONE_TYPE;
    }

    public static IRType undefined() {
        return UNDEFINED_TYPE;
    }

    public static IRType union(List<IRType> targets) {
        UnionTypeKey union = new UnionTypeKey();
        union.targets.addAll(targets);
        return union;
    }

    public static IRType functionType(List<IRParameter> parameters, IRType returnType) {
        return new FunctionTypeKey(parameters, returnType);
    }

    public static JSTypeSet create() {
        return new JSTypeSetImpl();
    }

    public static JSTypeSet create(IRType type) {
        if (type == null || type == JSTypeSet.none()) {
            return JSTypeSet.emptySet();
        }
        JSTypeSetImpl set = new JSTypeSetImpl();
        ((JSTypeSet)set).add(type);
        return set;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSTypeSet) {
            JSTypeSet other = (JSTypeSet)obj;
            return this.size() == other.size() && this.containsAll(other);
        }
        return false;
    }

    public abstract void add(IRType var1);

    public abstract IRType getFirst();

    public abstract IRType toRType();

    public abstract Type[] toArray();

    public abstract int size();

    public abstract void addAll(JSTypeSet var1);

    public abstract boolean isEmpty();

    public abstract void clear();

    public abstract boolean contains(IRType var1);

    public abstract boolean contains(Type var1);

    public abstract boolean containsAll(JSTypeSet var1);

    private static class AnyTypeKey
    extends TypeKey
    implements IRAnyType {
        private AnyTypeKey() {
        }

        public String getName() {
            return "Any";
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.TRUE;
        }
    }

    private static class ArrayTypeKey
    extends TypeKey
    implements IRArrayType {
        private final IRType itemType;

        public ArrayTypeKey(ITypeSystem typeSystem, IRType itemType) {
            super(typeSystem);
            this.itemType = itemType;
        }

        public ArrayTypeKey(IRType itemType) {
            this.itemType = itemType;
        }

        public String getName() {
            return "Array<" + this.itemType.getName() + '>';
        }

        public IRType getItemType() {
            return this.itemType;
        }

        public int hashCode() {
            return this.itemType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArrayTypeKey) {
                ArrayTypeKey other = (ArrayTypeKey)obj;
                return this.itemType.equals(other.itemType);
            }
            return false;
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            if (super.isAssignableFrom(type).ok()) {
                return TypeCompatibility.TRUE;
            }
            if (type instanceof ArrayTypeKey) {
                TypeCompatibility compatibility = this.itemType.isAssignableFrom(((ArrayTypeKey)type).itemType);
                return compatibility == TypeCompatibility.TRUE ? compatibility : TypeCompatibility.UNPARAMETERIZED;
            }
            return TypeCompatibility.FALSE;
        }
    }

    public static class ClassTypeKey
    extends TypeKey
    implements IRClassType {
        protected final Type type;

        public ClassTypeKey(Type type) {
            this.type = type;
        }

        public String getRawName() {
            if (this.type != null) {
                if (this.type.eIsProxy()) {
                    URI uri = ((InternalEObject)this.type).eProxyURI();
                    if (uri != null) {
                        return URI.decode((String)uri.fragment());
                    }
                } else {
                    return this.type.getName();
                }
            }
            return null;
        }

        public String getName() {
            String rawName = this.getRawName();
            return rawName != null ? "Class<" + rawName + ">" : "Class";
        }

        public Type getTarget() {
            return this.type;
        }

        public IRType toItemType() {
            if (this.type == null) {
                return JSTypeSet.any();
            }
            if ("Array".equals(this.type.getName())) {
                return JSTypeSet.arrayOf(JSTypeSet.none());
            }
            return new SimpleTypeKey(this.type);
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 31;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassTypeKey) {
                ClassTypeKey other = (ClassTypeKey)obj;
                return this.type != null ? this.type.equals(other.type) : other.type == null;
            }
            return false;
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            if (super.isAssignableFrom(type).ok()) {
                return TypeCompatibility.TRUE;
            }
            if (type instanceof ClassTypeKey) {
                if (this.type == null) {
                    return TypeCompatibility.TRUE;
                }
                Type other = ((ClassTypeKey)type).getTarget();
                return TypeCompatibility.valueOf(other == null || this.isAssignableFrom(this.type, other));
            }
            return TypeCompatibility.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<IRType> {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IRType next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionTypeKey
    extends TypeKey
    implements IRFunctionType {
        private final List<IRParameter> parameters;
        private final IRType returnType;

        public FunctionTypeKey(List<IRParameter> parameters, IRType returnType) {
            this.parameters = parameters;
            this.returnType = returnType;
        }

        @Override
        public String getName() {
            StringBuilder sb = new StringBuilder();
            sb.append("function");
            sb.append('(');
            int index = 0;
            for (IRParameter parameter : this.parameters) {
                if (++index != 1) {
                    sb.append(", ");
                }
                if (parameter.getKind() == ParameterKind.VARARGS) {
                    sb.append("...");
                }
                sb.append(parameter.getType());
                if (parameter.getKind() != ParameterKind.OPTIONAL) continue;
                sb.append("=");
            }
            sb.append(')');
            if (this.returnType != null) {
                sb.append(':');
                sb.append(this.returnType);
            }
            return sb.toString();
        }

        @Override
        public TypeCompatibility isAssignableFrom(IRType type) {
            if (super.isAssignableFrom(type).ok()) {
                return TypeCompatibility.TRUE;
            }
            if (type instanceof FunctionTypeKey) {
                return TypeCompatibility.TRUE;
            }
            if (type instanceof SimpleTypeKey) {
                return TypeCompatibility.valueOf("Function".equals(type.getName()));
            }
            return TypeCompatibility.FALSE;
        }

        @Override
        public IRType getReturnType() {
            return this.returnType;
        }

        @Override
        public List<IRParameter> getParameters() {
            return this.parameters;
        }

        public int hashCode() {
            return this.parameters.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionTypeKey other = (FunctionTypeKey)obj;
            if (!this.parameters.equals(other.parameters)) {
                return false;
            }
            return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSEmptyTypeSet
    extends JSTypeSet {
        protected JSEmptyTypeSet() {
        }

        @Override
        public Iterator<IRType> iterator() {
            return new EmptyIterator();
        }

        @Override
        public void add(IRType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IRType getFirst() {
            return null;
        }

        @Override
        public IRType toRType() {
            return JSEmptyTypeSet.none();
        }

        @Override
        public Type[] toArray() {
            return new Type[0];
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void addAll(JSTypeSet types) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(IRType type) {
            return false;
        }

        @Override
        public boolean contains(Type type) {
            return false;
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            return types.isEmpty();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSSingletonTypeSet
    extends JSTypeSet {
        private final IRType type;

        public JSSingletonTypeSet(IRType type) {
            this.type = type;
        }

        @Override
        public Iterator<IRType> iterator() {
            return new SingletonIterator(this.type);
        }

        @Override
        public void add(IRType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IRType getFirst() {
            return this.type;
        }

        @Override
        public IRType toRType() {
            return this.type;
        }

        @Override
        public Type[] toArray() {
            if (this.type instanceof SimpleTypeKey) {
                return new Type[]{((SimpleTypeKey)this.type).getTarget()};
            }
            if (this.type instanceof ClassTypeKey) {
                return new Type[]{((ClassTypeKey)this.type).getTarget()};
            }
            if (this.type instanceof AnyTypeKey) {
                return new Type[]{TypeInfoModelLoader.getInstance().getType("Object")};
            }
            return new Type[0];
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void addAll(JSTypeSet types) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(IRType type) {
            return this.type.equals(type);
        }

        @Override
        public boolean contains(Type type) {
            return this.type instanceof SimpleTypeKey && ((SimpleTypeKey)this.type).getTarget().equals(type);
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            return types.size() == 1 && this.contains(types.getFirst());
        }

        public String toString() {
            return "[" + this.type + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSTypeSetImpl
    extends JSTypeSet {
        private final List<IRType> types = new ArrayList<IRType>(3);

        protected JSTypeSetImpl() {
        }

        @Override
        public Iterator<IRType> iterator() {
            return this.types.iterator();
        }

        @Override
        public void add(IRType type) {
            if (type instanceof IRUnionType) {
                for (IRType t : ((IRUnionType)type).getTargets()) {
                    this.add(t);
                }
            } else if (!this.types.contains(type)) {
                this.types.add(type);
            }
        }

        @Override
        public IRType getFirst() {
            return this.types.iterator().next();
        }

        @Override
        public IRType toRType() {
            if (this.types.isEmpty()) {
                return JSTypeSetImpl.none();
            }
            if (this.types.size() == 1) {
                return this.types.iterator().next();
            }
            return JSTypeSetImpl.union(this.types);
        }

        @Override
        public Type[] toArray() {
            LinkedHashSet<Type> result = new LinkedHashSet<Type>();
            for (IRType type : this.types) {
                if (type instanceof SimpleTypeKey) {
                    result.add(((SimpleTypeKey)type).getTarget());
                    continue;
                }
                if (!(type instanceof AnyTypeKey)) continue;
                result.add(TypeInfoModelLoader.getInstance().getType("Object"));
            }
            return result.toArray(new Type[result.size()]);
        }

        @Override
        public int size() {
            return this.types.size();
        }

        @Override
        public void addAll(JSTypeSet types) {
            for (IRType type : types) {
                this.add(type);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.types.isEmpty();
        }

        @Override
        public void clear() {
            this.types.clear();
        }

        @Override
        public boolean contains(IRType type) {
            return this.types.contains(type);
        }

        @Override
        public boolean contains(Type type) {
            return this.types.contains(JSTypeSetImpl.ref(type));
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            for (IRType type : types) {
                if (this.contains(type)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.types.toString();
        }
    }

    private static class MapTypeKey
    extends TypeKey
    implements IRMapType {
        private final IRType valueType;
        private final IRType keyType;

        public MapTypeKey(IRType keyType, IRType valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public String getName() {
            if (this.valueType != null && this.keyType != null && !"String".equals(this.keyType.getName())) {
                return "Object<" + this.keyType.getName() + ',' + this.valueType.getName() + '>';
            }
            return this.valueType != null ? "Object<" + this.valueType.getName() + '>' : "Object";
        }

        public int hashCode() {
            return this.valueType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MapTypeKey) {
                MapTypeKey other = (MapTypeKey)obj;
                return this.valueType.equals(other.valueType);
            }
            return false;
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            if (super.isAssignableFrom(type).ok()) {
                return TypeCompatibility.TRUE;
            }
            if (type instanceof MapTypeKey) {
                return this.valueType.isAssignableFrom(((MapTypeKey)type).valueType);
            }
            return TypeCompatibility.FALSE;
        }

        public IRType getKeyType() {
            return this.keyType;
        }

        public IRType getValueType() {
            return this.valueType;
        }
    }

    private static class NoneTypeKey
    extends TypeKey
    implements IRNoneType {
        private NoneTypeKey() {
        }

        public String getName() {
            return "None";
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.TRUE;
        }
    }

    private static class RRecordMember
    implements IRRecordMember {
        final String name;
        final IRType type;
        final boolean optional;
        final Member member;

        public RRecordMember(String name, IRType type, Member member) {
            this.name = name;
            this.type = type;
            this.optional = member instanceof RecordMember && ((RecordMember)member).isOptional();
            this.member = member;
        }

        public String getName() {
            return this.name;
        }

        public IRType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return String.valueOf(this.name) + ":" + this.type;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RRecordMember) {
                RRecordMember other = (RRecordMember)obj;
                return this.name.equals(other.name) && this.type.equals(other.type);
            }
            return false;
        }

        public Member getMember() {
            return this.member;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecordTypeKey
    extends TypeKey
    implements IRRecordType {
        private final Map<String, IRRecordMember> members = new LinkedHashMap<String, IRRecordMember>();

        public RecordTypeKey(ITypeSystem context, List<Member> members) {
            for (Member member : members) {
                IRType memberType = member.getType() != null ? JSTypeSet.normalize(context, member.getType()) : ANY_TYPE;
                this.members.put(member.getName(), new RRecordMember(member.getName(), memberType, member));
            }
        }

        @Override
        public String getName() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            for (IRRecordMember member : this.members.values()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                sb.append(member.getName());
                if (member.getType() instanceof IRAnyType) continue;
                sb.append(':');
                sb.append(member.getType().getName());
            }
            sb.append('}');
            return sb.toString();
        }

        @Override
        public IRRecordMember getMember(String name) {
            return this.members.get(name);
        }

        @Override
        public Collection<IRRecordMember> getMembers() {
            return this.members.values();
        }

        @Override
        public TypeCompatibility isAssignableFrom(IRType type) {
            if (super.isAssignableFrom(type).ok()) {
                return TypeCompatibility.TRUE;
            }
            if (type instanceof RecordTypeKey) {
                Map<String, IRRecordMember> others = ((RecordTypeKey)type).members;
                for (Map.Entry<String, IRRecordMember> entry : others.entrySet()) {
                    IRRecordMember member = this.members.get(entry.getKey());
                    if (member == null) {
                        return TypeCompatibility.FALSE;
                    }
                    if (member.getType().isAssignableFrom(entry.getValue().getType()).ok()) continue;
                    return TypeCompatibility.FALSE;
                }
                for (Map.Entry<String, IRRecordMember> entry : this.members.entrySet()) {
                    if (entry.getValue().isOptional() || others.containsKey(entry.getKey())) continue;
                    return TypeCompatibility.FALSE;
                }
                return TypeCompatibility.TRUE;
            }
            return TypeCompatibility.FALSE;
        }

        public int hashCode() {
            return this.members.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecordTypeKey) {
                RecordTypeKey other = (RecordTypeKey)obj;
                return this.members.equals(other.members);
            }
            return false;
        }
    }

    public static class SimpleTypeKey
    extends TypeKey
    implements IRSimpleType {
        private final Type type;

        public SimpleTypeKey(ITypeSystem typeSystem, Type type) {
            super(typeSystem);
            this.type = type;
        }

        public SimpleTypeKey(Type type) {
            this.type = type;
        }

        public String getName() {
            return this.type.getName();
        }

        public Type getTarget() {
            return this.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SimpleTypeKey) {
                SimpleTypeKey other = (SimpleTypeKey)obj;
                return this.type.equals(other.type);
            }
            return false;
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            if (super.isAssignableFrom(type).ok()) {
                return TypeCompatibility.TRUE;
            }
            if ("Object".equals(this.getName())) {
                return TypeCompatibility.TRUE;
            }
            if (type instanceof SimpleTypeKey) {
                Type other = ((SimpleTypeKey)type).getTarget();
                if (this.isAssignableFrom(this.type, other)) {
                    return TypeCompatibility.TRUE;
                }
                OriginReference origin = OriginReference.of(this.type);
                if (origin != null) {
                    if (this.isAssignableFrom(origin.genericType, other)) {
                        return TypeCompatibility.TRUE;
                    }
                    OriginReference otherOrigin = OriginReference.of(other);
                    if (otherOrigin != null && this.isAssignableFrom(origin.genericType, otherOrigin.genericType) && this.isAssignableFrom(origin.parameterTypes, otherOrigin.parameterTypes)) {
                        return TypeCompatibility.TRUE;
                    }
                }
            }
            return TypeCompatibility.FALSE;
        }

        private boolean isAssignableFrom(IRType[] dest, IRType[] src) {
            if (dest.length == src.length) {
                int i = 0;
                while (i < dest.length) {
                    if (dest[i].isAssignableFrom(src[i]) != TypeCompatibility.TRUE) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterator
    implements Iterator<IRType> {
        private final IRType type;
        private boolean hasNext = true;

        public SingletonIterator(IRType type) {
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public IRType next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.type;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class TypeKey
    implements IRType {
        protected final ITypeSystem typeSystem;

        protected TypeKey() {
            this(null);
        }

        protected TypeKey(ITypeSystem typeSystem) {
            this.typeSystem = typeSystem;
        }

        public ITypeSystem activeTypeSystem() {
            return this.typeSystem;
        }

        protected final void checkType(Type type) {
            if (type.isProxy()) {
                System.out.println("PROXY " + type.getName());
            }
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            if (type == UNDEFINED_TYPE || type == ANY_TYPE) {
                return TypeCompatibility.TRUE;
            }
            if (type == NONE_TYPE) {
                return TypeCompatibility.FALSE;
            }
            if (type instanceof UnionTypeKey) {
                for (IRType part : ((UnionTypeKey)type).targets) {
                    if (!this.isAssignableFrom(part).ok()) continue;
                    return TypeCompatibility.TRUE;
                }
            }
            return TypeCompatibility.FALSE;
        }

        protected boolean isAssignableFrom(Type dest, Type src) {
            String localName = TypeUtil.getName(dest);
            for (Type t : new TypeQuery(src).getHierarchy()) {
                if (!localName.equals(TypeUtil.getName(t))) continue;
                return true;
            }
            return false;
        }

        public final String toString() {
            return this.getName();
        }
    }

    private static class UndefinedTypeKey
    extends TypeKey
    implements IRUndefinedType {
        private UndefinedTypeKey() {
        }

        public String getName() {
            return "undefined";
        }

        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.valueOf(type == this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnionTypeKey
    extends TypeKey
    implements IRUnionType {
        final Set<IRType> targets = new LinkedHashSet<IRType>();

        private UnionTypeKey() {
        }

        @Override
        public String getName() {
            StringBuilder sb = new StringBuilder();
            for (IRType type : this.targets) {
                if (sb.length() != 0) {
                    sb.append('|');
                }
                sb.append(type.getName());
            }
            return sb.toString();
        }

        @Override
        public TypeCompatibility isAssignableFrom(IRType type) {
            for (IRType target : this.targets) {
                if (!target.isAssignableFrom(type).ok()) continue;
                return TypeCompatibility.TRUE;
            }
            return TypeCompatibility.FALSE;
        }

        @Override
        public Set<IRType> getTargets() {
            return Collections.unmodifiableSet(this.targets);
        }

        public int hashCode() {
            return this.targets.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnionTypeKey) {
                UnionTypeKey other = (UnionTypeKey)obj;
                return this.targets.equals(other.targets);
            }
            return false;
        }
    }
}

