/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.ConstantValue;
import org.eclipse.dltk.internal.javascript.ti.FunctionValueCollection;
import org.eclipse.dltk.internal.javascript.ti.IReferenceAttributes;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.JSVariable;
import org.eclipse.dltk.internal.javascript.ti.LazyTypeReference;
import org.eclipse.dltk.internal.javascript.ti.NestedValueCollection;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitorBase;
import org.eclipse.dltk.internal.javascript.ti.WithValueCollection;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSScope;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlExpressionFragment;
import org.eclipse.dltk.javascript.ast.XmlFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilderExtension;
import org.eclipse.dltk.javascript.typeinfo.IRAnyType;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRNoneType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRVariable;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.GenericMethod;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableClassType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableReference;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.dltk.javascript.typeinfo.model.util.TypeInfoModelSwitch;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInferencerVisitor
extends TypeInferencerVisitorBase {
    private final Stack<Branching> branchings = new Stack();
    private static final TypeInfoModelSwitch<Boolean> GENERIC_TYPE_EXPRESSION = new TypeInfoModelSwitch<Boolean>(){

        @Override
        public Boolean doSwitch(EObject theEObject) {
            return theEObject != null ? (Boolean)super.doSwitch(theEObject) : null;
        }

        @Override
        public Boolean caseJSType(JSType object) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseTypeVariableReference(TypeVariableReference object) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseTypeVariableClassType(TypeVariableClassType object) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseArrayType(ArrayType object) {
            return this.doSwitch(object.getItemType());
        }

        @Override
        public Boolean caseMapType(MapType object) {
            Boolean result = this.doSwitch(object.getKeyType());
            if (result == Boolean.TRUE) {
                return result;
            }
            return this.doSwitch(object.getValueType());
        }

        @Override
        public Boolean caseUnionType(UnionType object) {
            for (JSType type : object.getTargets()) {
                Boolean result = this.doSwitch(type);
                if (result != Boolean.TRUE) continue;
                return result;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseFunctionType(FunctionType object) {
            for (Parameter parameter : object.getParameters()) {
                Boolean result = this.doSwitch(parameter.getType());
                if (result != Boolean.TRUE) continue;
                return result;
            }
            return this.doSwitch(object.getReturnType());
        }
    };
    protected static final IAssignProtection PROTECT_CONST = new IAssignProtection(){

        public IProblemIdentifier problemId() {
            return JavaScriptProblems.REASSIGNMENT_OF_CONSTANT;
        }

        public String problemMessage() {
            return ValidationMessages.ReassignmentOfConstant;
        }
    };
    private static final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder docBuilder;

    public TypeInferencerVisitor(ITypeInferenceContext context) {
        super(context);
    }

    protected Branching branching() {
        Branching branching = new Branching();
        this.branchings.add(branching);
        return branching;
    }

    @Override
    public ReferenceSource getSource() {
        ReferenceSource source = this.context.getSource();
        return source != null ? source : ReferenceSource.UNKNOWN;
    }

    protected void assign(IValueReference dest, IValueReference src) {
        IRType srcType;
        IRType destType = JavaScriptValidations.typeOf(dest);
        if (destType != null && TypeInferencerVisitor.isXML(destType) && (srcType = JavaScriptValidations.typeOf(src)) != null && !TypeInferencerVisitor.isXML(srcType)) {
            return;
        }
        if (this.branchings.isEmpty()) {
            dest.setValue(src);
        } else {
            dest.addValue(src, false);
        }
    }

    private static boolean isXML(IRType srcType) {
        return srcType instanceof IRSimpleType && ("XML".equals(srcType.getName()) || "XMLList".equals(srcType.getName()));
    }

    public IValueReference visitArrayInitializer(ArrayInitializer node) {
        JSTypeSet types = JSTypeSet.create();
        for (ASTNode astNode : node.getItems()) {
            IValueReference child;
            if (astNode instanceof StringLiteral) {
                types.add(JSTypeSet.ref("String"));
                continue;
            }
            if (astNode instanceof DecimalLiteral) {
                types.add(JSTypeSet.ref("Number"));
                continue;
            }
            if (astNode instanceof BooleanLiteral) {
                types.add(JSTypeSet.ref("Boolean"));
                continue;
            }
            if (astNode instanceof NullExpression || astNode instanceof EmptyExpression || (child = this.visit(astNode)) == null || !child.exists()) continue;
            types.addAll(JavaScriptValidations.getTypes(child));
        }
        if (types.size() == 1) {
            return this.context.getFactory().create(this.peekContext(), JSTypeSet.arrayOf(types.getFirst()));
        }
        return this.context.getFactory().createArray(this.peekContext());
    }

    public IValueReference visitAsteriskExpression(AsteriskExpression node) {
        return this.context.getFactory().createXMLList(this.peekContext());
    }

    public IValueReference visitBinaryOperation(BinaryOperation node) {
        IValueReference left = this.visit((ASTNode)node.getLeftExpression());
        int op = node.getOperation();
        if (104 == op) {
            if (left != null) {
                IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
                int n = iModelBuilderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelBuilder modelBuilder = iModelBuilderArray[n2];
                    if (modelBuilder instanceof IModelBuilderExtension) {
                        ((IModelBuilderExtension)modelBuilder).processAssignment(node.getLeftExpression(), left);
                    }
                    ++n2;
                }
            }
            if (left != null && left.exists()) {
                IValueReference r;
                left.setAttribute("RESOLVING", Boolean.TRUE);
                try {
                    r = this.visit((ASTNode)node.getRightExpression());
                }
                finally {
                    left.setAttribute("RESOLVING", null);
                }
                return this.visitAssign(left, r, node);
            }
            return this.visitAssign(left, this.visit((ASTNode)node.getRightExpression()), node);
        }
        IValueReference right = this.visit((ASTNode)node.getRightExpression());
        if (left == null && right instanceof ConstantValue) {
            return right;
        }
        if (op == 100) {
            return TypeInferencerVisitor.coalesce(right, left);
        }
        if (op == 79 || op == 81 || op == 78 || op == 80 || op == 85 || op == 84 || op == 83 || op == 82) {
            return this.context.getFactory().createBoolean(this.peekContext());
        }
        if (this.isNumber(left) && this.isNumber(right)) {
            return this.context.getFactory().createNumber(this.peekContext());
        }
        if (op == 86) {
            if (this.isString(left) || this.isString(right)) {
                return this.context.getFactory().createString(this.peekContext());
            }
            return left;
        }
        if (21 == op) {
            return this.context.getFactory().createBoolean(this.peekContext());
        }
        if (101 == op) {
            JSTypeSet typeSet = JSTypeSet.create();
            if (left != null) {
                typeSet.addAll(left.getDeclaredTypes());
                typeSet.addAll(left.getTypes());
            }
            if (right != null) {
                typeSet.addAll(right.getDeclaredTypes());
                typeSet.addAll(right.getTypes());
            }
            return new ConstantValue(typeSet);
        }
        return null;
    }

    private static IValueReference coalesce(IValueReference v1, IValueReference v2) {
        return v1 != null ? v1 : v2;
    }

    private boolean isNumber(IValueReference ref) {
        if (ref != null) {
            IRType numType = JSTypeSet.ref("Number");
            if (ref.getTypes().contains(numType)) {
                return true;
            }
            if (numType.equals(ref.getDeclaredType())) {
                return true;
            }
        }
        return false;
    }

    private boolean isString(IValueReference ref) {
        if (ref != null) {
            IRType strType = JSTypeSet.ref("String");
            if (ref.getTypes().contains(strType)) {
                return true;
            }
            if (strType.equals(ref.getDeclaredType())) {
                return true;
            }
        }
        return false;
    }

    protected IValueReference visitAssign(IValueReference left, IValueReference right, BinaryOperation node) {
        if (left != null) {
            PropertyExpression property;
            if (node.getLeftExpression() instanceof PropertyExpression && (property = (PropertyExpression)node.getLeftExpression()).getObject() instanceof ThisExpression && property.getProperty() instanceof Identifier && !left.exists()) {
                if (TypeInferencerVisitor.isFunctionDeclaration((Expression)property)) {
                    left.setKind(ReferenceKind.FUNCTION);
                } else {
                    left.setKind(ReferenceKind.FIELD);
                }
                left.setLocation(ReferenceLocation.create(this.getSource(), property.sourceStart(), property.sourceEnd(), property.getProperty().sourceStart(), property.getProperty().sourceEnd()));
            }
            if ("[]".equals(left.getName()) && node.getLeftExpression() instanceof GetArrayItemExpression) {
                GetArrayItemExpression arrayItemExpression = (GetArrayItemExpression)node.getLeftExpression();
                IValueReference namedChild = this.extractNamedChild(left.getParent(), arrayItemExpression.getIndex());
                if (namedChild != null) {
                    this.assign(namedChild, right);
                } else {
                    this.assign(left, right);
                }
            } else if (!this.hasUnknowParentFunctionCall(left)) {
                this.assign(left, right);
            }
        }
        return right;
    }

    private boolean hasUnknowParentFunctionCall(IValueReference reference) {
        IValueReference parent = reference.getParent();
        while (parent != null) {
            if (parent.getName().equals("()") && !parent.exists()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public IValueReference visitBooleanLiteral(BooleanLiteral node) {
        return this.context.getFactory().createBoolean(this.peekContext());
    }

    public IValueReference visitBreakStatement(BreakStatement node) {
        return null;
    }

    public IValueReference visitCallExpression(CallExpression node) {
        IValueReference reference = this.visit((ASTNode)node.getExpression());
        List args = node.getArguments();
        IValueReference[] arguments = new IValueReference[args.size()];
        int i = 0;
        while (i < args.size()) {
            arguments[i] = this.visit((ASTNode)args.get(i));
            ++i;
        }
        if (reference != null) {
            List<Method> methods = JavaScriptValidations.extractElements(reference, Method.class);
            if (methods != null && methods.size() == 1) {
                if (methods.get(0) instanceof GenericMethod) {
                    GenericMethod method = (GenericMethod)methods.get(0);
                    JSTypeSet type = this.evaluateGenericCall(method, arguments);
                    if (type != null) {
                        return new ConstantValue(type);
                    }
                } else {
                    ITypeSystem typeSystem = this.getTypeSystemOf(reference);
                    IRType type = JSTypeSet.normalize(typeSystem, methods.get(0).getType());
                    if (type != null) {
                        return new ConstantValue(type);
                    }
                    return null;
                }
            }
            return reference.getChild("()");
        }
        return null;
    }

    private ITypeSystem getTypeSystemOf(IValueReference reference) {
        Object value = reference.getAttribute(IReferenceAttributes.TYPE_SYSTEM);
        if (value != null) {
            return (ITypeSystem)value;
        }
        return this.getContext();
    }

    protected JSTypeSet evaluateGenericCall(GenericMethod method, IValueReference[] arguments) {
        JSTypeSet[] argTypes = new JSTypeSet[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argTypes[i] = arguments[i].getDeclaredTypes();
            if (argTypes[i].isEmpty()) {
                argTypes[i] = arguments[i].getTypes();
            }
            ++i;
        }
        boolean[] genericParams = new boolean[method.getParameters().size()];
        int i2 = 0;
        while (i2 < method.getParameters().size()) {
            genericParams[i2] = this.isGenericType(((Parameter)method.getParameters().get(i2)).getType());
            ++i2;
        }
        HashMap<TypeVariable, JSTypeSet> captures = new HashMap<TypeVariable, JSTypeSet>();
        for (TypeVariable variable : method.getTypeParameters()) {
            captures.put(variable, JSTypeSet.create());
        }
        int i3 = 0;
        while (i3 < argTypes.length) {
            JSTypeSet captured;
            Capture capture;
            int index = i3 < method.getParameters().size() ? i3 : method.getParameters().size() - 1;
            Parameter parameter = (Parameter)method.getParameters().get(index);
            if (genericParams[index] && (capture = this.capture(parameter.getType(), argTypes[i3])) != null && (captured = (JSTypeSet)captures.get(capture.variable)) != null) {
                captured.addAll(capture.types);
            }
            ++i3;
        }
        if (method.getType() != null) {
            return this.evaluateReturnType(method.getType(), captures);
        }
        return null;
    }

    private JSTypeSet evaluateReturnType(JSType type, Map<TypeVariable, JSTypeSet> captures) {
        if (type instanceof TypeVariableReference) {
            TypeVariable variable = ((TypeVariableReference)type).getVariable();
            return this.normalizeCapture(captures.get(variable));
        }
        if (type instanceof ArrayType) {
            JSType itemType = ((ArrayType)type).getItemType();
            return JSTypeSet.singleton(JSTypeSet.arrayOf(this.evaluateReturnType(itemType, captures).toRType()));
        }
        if (type instanceof ParameterizedType) {
            ArrayList<IRType> params = new ArrayList<IRType>();
            ParameterizedType parameterized = (ParameterizedType)type;
            for (JSType param : parameterized.getActualTypeArguments()) {
                params.add(this.evaluateReturnType(param, captures).toRType());
            }
            return JSTypeSet.singleton(JSTypeSet.ref(this.getContext().parameterize(parameterized.getTarget(), params)));
        }
        if (type instanceof SimpleType) {
            return JSTypeSet.create(JSTypeSet.normalize(this.getContext(), type));
        }
        return JSTypeSet.emptySet();
    }

    private JSTypeSet normalizeCapture(JSTypeSet types) {
        return types;
    }

    private Capture capture(JSType paramType, JSTypeSet argTypes) {
        if (paramType instanceof TypeVariableReference) {
            return new Capture(((TypeVariableReference)paramType).getVariable(), argTypes);
        }
        if (paramType instanceof TypeVariableClassType) {
            JSTypeSet result = JSTypeSet.create();
            for (IRType type : argTypes) {
                if (!(type instanceof IRClassType)) continue;
                result.add(((IRClassType)type).toItemType());
            }
            return new Capture(((TypeVariableClassType)paramType).getVariable(), result);
        }
        return null;
    }

    private boolean isGenericType(JSType type) {
        if (type != null) {
            Boolean result = GENERIC_TYPE_EXPRESSION.doSwitch(type);
            return result != null && result != false;
        }
        return false;
    }

    public IValueReference visitCommaExpression(CommaExpression node) {
        return (IValueReference)this.visit(node.getItems());
    }

    public IValueReference visitConditionalOperator(ConditionalOperator node) {
        this.visit((ASTNode)node.getCondition());
        return this.merge(this.visit((ASTNode)node.getTrueValue()), this.visit((ASTNode)node.getFalseValue()));
    }

    public IValueReference visitConstDeclaration(ConstStatement node) {
        IValueCollection context = this.peekContext();
        for (VariableDeclaration declaration : node.getVariables()) {
            IValueReference constant = this.createVariable(context, declaration);
            if (constant == null) continue;
            constant.setAttribute(IAssignProtection.ATTRIBUTE, PROTECT_CONST);
        }
        return null;
    }

    protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
        Identifier identifier = declaration.getIdentifier();
        String varName = identifier.getName();
        IValueReference reference = context.createChild(varName);
        JSVariable variable = new JSVariable();
        variable.setName(declaration.getVariableName());
        if (declaration.getParent() instanceof VariableStatement) {
            IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
            int n = iModelBuilderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelBuilder extension = iModelBuilderArray[n2];
                extension.processVariable(declaration, variable, this.reporter, this.getTypeChecker());
                ++n2;
            }
        }
        reference.setAttribute("VARIABLE", variable);
        reference.setKind(this.inFunction() ? ReferenceKind.LOCAL : ReferenceKind.GLOBAL);
        reference.setLocation(ReferenceLocation.create(this.getSource(), declaration.sourceStart(), declaration.sourceEnd(), identifier.sourceStart(), identifier.sourceEnd()));
        this.initializeVariable(reference, declaration, variable);
        IRVariable rvar = RModelBuilder.create((ITypeSystem)this.getContext(), variable);
        reference.setAttribute("R_VARIABLE", rvar);
        if (rvar.getType() != null) {
            this.setIRType(reference, rvar.getType(), true);
        }
        return reference;
    }

    protected void initializeVariable(IValueReference reference, VariableDeclaration declaration, IModelBuilder.IVariable variable) {
        if (declaration.getInitializer() != null) {
            IValueReference assignment;
            reference.setAttribute("RESOLVING", Boolean.TRUE);
            try {
                assignment = this.visit((ASTNode)declaration.getInitializer());
            }
            finally {
                reference.setAttribute("RESOLVING", null);
            }
            if (assignment != null) {
                this.assign(reference, assignment);
                if (assignment.getKind() == ReferenceKind.FUNCTION && reference.getAttribute("METHOD") != null) {
                    reference.setKind(ReferenceKind.FUNCTION);
                }
            }
        }
    }

    public IValueReference visitContinueStatement(ContinueStatement node) {
        return null;
    }

    public IValueReference visitDecimalLiteral(DecimalLiteral node) {
        return this.context.getFactory().createNumber(this.peekContext());
    }

    public IValueReference visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
        this.visit((ASTNode)node.getValue());
        return null;
    }

    public IValueReference visitDoWhileStatement(DoWhileStatement node) {
        this.visit((ASTNode)node.getCondition());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitEmptyExpression(EmptyExpression node) {
        return null;
    }

    public IValueReference visitEmptyStatement(EmptyStatement node) {
        return null;
    }

    public IValueReference visitForEachInStatement(ForEachInStatement node) {
        IValueReference itemReference = this.visit((ASTNode)node.getItem());
        IValueReference iteratorReference = this.visit((ASTNode)node.getIterator());
        JSTypeSet typeSet = JavaScriptValidations.getTypes(iteratorReference);
        if (!typeSet.isEmpty()) {
            IRType itemType;
            IRType type = null;
            for (IRType irType : typeSet) {
                IRType itemType2;
                if (type == null) {
                    type = irType;
                    continue;
                }
                if (irType instanceof IRArrayType) {
                    itemType2 = ((IRArrayType)irType).getItemType();
                    if (itemType2 instanceof IRNoneType || itemType2 instanceof IRAnyType) continue;
                    type = irType;
                    continue;
                }
                if (!(irType instanceof IRMapType) || (itemType2 = ((IRMapType)irType).getValueType()) instanceof IRNoneType || itemType2 instanceof IRAnyType) continue;
                type = irType;
            }
            if (type instanceof IRArrayType && JavaScriptValidations.typeOf(itemReference) == null) {
                itemType = ((IRArrayType)type).getItemType();
                this.setIRType(itemReference, itemType, true);
            } else if (type instanceof IRMapType && JavaScriptValidations.typeOf(itemReference) == null) {
                itemType = ((IRMapType)type).getValueType();
                this.setIRType(itemReference, itemType, true);
            } else if ("XMLList".equals(type.getName())) {
                itemReference.setDeclaredType(JSTypeSet.ref(this.context.getType("XML")));
            }
        }
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForInStatement(ForInStatement node) {
        IValueReference item = this.visit((ASTNode)node.getItem());
        if (item != null) {
            this.assign(item, this.context.getFactory().createString(this.peekContext()));
        }
        this.visit((ASTNode)node.getIterator());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForStatement(ForStatement node) {
        if (node.getInitial() != null) {
            this.visit((ASTNode)node.getInitial());
        }
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getStep() != null) {
            this.visit((ASTNode)node.getStep());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    public IValueReference visitFunctionStatement(FunctionStatement node) {
        JSMethod method = this.generateJSMethod(node);
        FunctionValueCollection function = new FunctionValueCollection(this.peekContext(), method.getName(), node.isInlineBlock());
        for (IModelBuilder.IParameter parameter : method.getParameters()) {
            IValueReference refArg = function.createChild(parameter.getName());
            refArg.setKind(ReferenceKind.ARGUMENT);
            this.setTypeImpl(refArg, parameter.getType());
            refArg.setLocation(parameter.getLocation());
        }
        node.getName();
        IValueReference result = TypeInferencerVisitor.isChildFunction(node) ? this.peekContext().createChild(method.getName()) : new AnonymousValue();
        result.setLocation(method.getLocation());
        result.setKind(ReferenceKind.FUNCTION);
        result.setDeclaredType(JSTypeSet.ref(this.context.getType("Function")));
        result.setAttribute("METHOD", method);
        result.setAttribute("R_METHOD", RModelBuilder.create((ITypeSystem)this.getContext(), method));
        result.setAttribute("FUNCTION_SCOPE", function);
        result.setAttribute("RESOLVING", Boolean.TRUE);
        this.enterContext(function);
        HashSet suppressed = null;
        try {
            if (this.reporter != null && !method.getSuppressedWarnings().isEmpty()) {
                suppressed = new HashSet();
                for (IProblemCategory category : method.getSuppressedWarnings()) {
                    suppressed.addAll(category.contents());
                }
                this.reporter.pushSuppressWarnings(suppressed);
            }
            this.visitFunctionBody(node);
        }
        finally {
            if (this.reporter != null && suppressed != null) {
                this.reporter.popSuppressWarnings();
            }
            this.leaveContext();
            result.setAttribute("RESOLVING", null);
        }
        IValueReference returnValue = result.getChild("()");
        returnValue.addValue(function.getReturnValue(), true);
        this.setTypeImpl(returnValue, method.getType());
        return result;
    }

    protected static boolean isChildFunction(FunctionStatement node) {
        return node.getName() != null && !(node.getParent() instanceof BinaryOperation) && !(node.getParent() instanceof VariableDeclaration) && !(node.getParent() instanceof PropertyInitializer) && !(node.getParent() instanceof NewExpression);
    }

    protected JSMethod generateJSMethod(FunctionStatement node) {
        JSMethod method = new JSMethod(node, this.getSource());
        IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
        int n = iModelBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder extension = iModelBuilderArray[n2];
            extension.processMethod(node, method, this.reporter, this.getTypeChecker());
            ++n2;
        }
        return method;
    }

    @Override
    public void visitFunctionBody(FunctionStatement node) {
        this.handleDeclarations((JSScope)node);
        this.visit((ASTNode)node.getBody());
    }

    @Override
    public void setType(IValueReference value, JSType type, boolean lazyEnabled) {
        this.setTypeImpl(value, type, lazyEnabled);
    }

    private void setTypeImpl(IValueReference value, JSType type) {
        this.setTypeImpl(value, type, true);
    }

    private void setTypeImpl(IValueReference value, JSType type, boolean lazyEnabled) {
        if (type == null) {
            return;
        }
        IRType rt = JSTypeSet.normalize(this.getContext(), type);
        this.setIRType(value, rt, lazyEnabled);
    }

    private void setIRType(IValueReference value, IRType rt, boolean lazyEnabled) {
        if (rt instanceof IRSimpleType) {
            Type t = ((IRSimpleType)rt).getTarget();
            if (t.getKind() != TypeKind.UNKNOWN) {
                value.setDeclaredType(rt);
                if (value instanceof IValueProvider) {
                    IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
                    int n = iMemberEvaluatorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
                        IValueCollection collection = evaluator.valueOf(this.context, t);
                        if (collection != null && collection instanceof IValueProvider) {
                            ((IValueProvider)((Object)value)).getValue().addValue(((IValueProvider)((Object)collection)).getValue());
                        }
                        ++n2;
                    }
                }
            } else if (lazyEnabled) {
                value.addValue(new LazyTypeReference(this.context, t.getName(), this.peekContext()), false);
            }
        } else {
            value.setDeclaredType(rt);
        }
    }

    public IValueReference visitGetAllChildrenExpression(GetAllChildrenExpression node) {
        return this.context.getFactory().createXMLList(this.peekContext());
    }

    public IValueReference visitGetArrayItemExpression(GetArrayItemExpression node) {
        IValueReference array = this.visit((ASTNode)node.getArray());
        this.visit((ASTNode)node.getIndex());
        if (array != null) {
            IValueReference namedChild;
            IValueReference child = array.getChild("[]");
            IRType arrayType = null;
            if (array.getDeclaredType() != null) {
                arrayType = TypeUtil.extractArrayItemType(array.getDeclaredType());
            } else {
                JSTypeSet types = array.getTypes();
                if (types.size() > 0) {
                    arrayType = TypeUtil.extractArrayItemType(types.getFirst());
                }
            }
            if (arrayType != null && child.getDeclaredType() == null) {
                this.setIRType(child, arrayType, true);
            }
            if (node.getIndex() instanceof StringLiteral && (namedChild = this.extractNamedChild(array, node.getIndex())).exists()) {
                child = namedChild;
                if (arrayType != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(arrayType);
                }
            }
            return child;
        }
        return null;
    }

    public IValueReference visitGetLocalNameExpression(GetLocalNameExpression node) {
        return null;
    }

    public IValueReference visitIdentifier(Identifier node) {
        return this.peekContext().getChild(node.getName());
    }

    private Boolean evaluateCondition(Expression condition) {
        if (condition instanceof BooleanLiteral) {
            return Boolean.valueOf(((BooleanLiteral)condition).getText());
        }
        return null;
    }

    public IValueReference visitIfStatement(IfStatement node) {
        this.visit((ASTNode)node.getCondition());
        this.visitIfStatements(node);
        return null;
    }

    protected void visitIfStatements(IfStatement node) {
        ArrayList<Statement> statements = new ArrayList<Statement>(2);
        Statement onlyBranch = null;
        Boolean condition = this.evaluateCondition(node.getCondition());
        if ((condition == null || condition.booleanValue()) && node.getThenStatement() != null) {
            statements.add(node.getThenStatement());
            if (condition != null && condition.booleanValue()) {
                onlyBranch = node.getThenStatement();
            }
        }
        if (!(condition != null && condition.booleanValue() || node.getElseStatement() == null)) {
            statements.add(node.getElseStatement());
            if (condition != null && !condition.booleanValue()) {
                onlyBranch = node.getElseStatement();
            }
        }
        if (!statements.isEmpty()) {
            if (statements.size() == 1) {
                if (statements.get(0) == onlyBranch) {
                    this.visit((ASTNode)statements.get(0));
                } else {
                    Branching branching = this.branching();
                    this.visit((ASTNode)statements.get(0));
                    branching.end();
                }
            } else {
                Branching branching = this.branching();
                ArrayList<NestedValueCollection> collections = new ArrayList<NestedValueCollection>(statements.size());
                for (Statement statement : statements) {
                    NestedValueCollection nestedCollection = new NestedValueCollection(this.peekContext());
                    this.enterContext(nestedCollection);
                    this.visit((ASTNode)statement);
                    this.leaveContext();
                    collections.add(nestedCollection);
                }
                NestedValueCollection.mergeTo(this.peekContext(), collections);
                branching.end();
            }
        }
    }

    public IValueReference visitLabelledStatement(LabelledStatement node) {
        if (node.getStatement() != null) {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    protected VisitNewResult visitNew(NewExpression node) {
        VisitNewResult result = new VisitNewResult();
        Expression objectClass = node.getObjectClass();
        if (objectClass instanceof CallExpression) {
            CallExpression call = (CallExpression)objectClass;
            result.arguments = new IValueReference[call.getArguments().size()];
            int index = 0;
            for (ASTNode argument : call.getArguments()) {
                result.arguments[index++] = this.visit(argument);
            }
            objectClass = call.getExpression();
        } else {
            result.arguments = new IValueReference[0];
        }
        result.typeValue = this.visit((ASTNode)objectClass);
        if (result.typeValue != null) {
            if (result.typeValue.getKind() == ReferenceKind.FUNCTION) {
                Object fs = result.typeValue.getAttribute("FUNCTION_SCOPE");
                if (fs instanceof IValueCollection && ((IValueCollection)fs).getThis() != null) {
                    result.value = new AnonymousNewValue();
                    result.value.setValue(((IValueCollection)fs).getThis());
                    result.value.setKind(ReferenceKind.TYPE);
                    String className = PropertyExpressionUtils.getPath((Expression)objectClass);
                    if (className != null) {
                        Type type = TypeInfoModelFactory.eINSTANCE.createType();
                        type.setSuperType(this.context.getKnownType("Object", null));
                        type.setKind(TypeKind.JAVASCRIPT);
                        type.setName(className);
                        result.value.setDeclaredType(JSTypeSet.ref(type));
                    } else {
                        result.value.setDeclaredType(JSTypeSet.ref("Object"));
                    }
                }
            } else if (result.typeValue.exists()) {
                for (IRType type : result.typeValue.getDeclaredTypes()) {
                    if (!(type instanceof IRClassType)) continue;
                    result.value = new AnonymousNewValue();
                    result.value.setKind(ReferenceKind.TYPE);
                    result.value.setDeclaredType(((IRClassType)type).toItemType());
                    return result;
                }
                for (IRType type : result.typeValue.getTypes()) {
                    if (!(type instanceof IRClassType)) continue;
                    result.value = new AnonymousNewValue();
                    result.value.setKind(ReferenceKind.TYPE);
                    result.value.setDeclaredType(((IRClassType)type).toItemType());
                    return result;
                }
            }
        }
        if (result.value == null) {
            String className = PropertyExpressionUtils.getPath((Expression)objectClass);
            IValueCollection contextValueCollection = this.peekContext();
            if (className != null) {
                Type knownType = this.context.getKnownType(className, TypeMode.CODE);
                if (knownType != null) {
                    result.value = new AnonymousNewValue();
                    result.value.setValue(this.context.getFactory().create(contextValueCollection, JSTypeSet.ref(knownType)));
                    result.value.setKind(ReferenceKind.TYPE);
                } else {
                    result.value = new LazyTypeReference(this.context, className, contextValueCollection);
                }
            } else {
                result.value = new AnonymousNewValue();
                result.value.setValue(this.context.getFactory().createObject(contextValueCollection));
            }
        }
        return result;
    }

    public IValueReference visitNewExpression(NewExpression node) {
        return this.visitNew(node).getValue();
    }

    public IValueReference visitNullExpression(NullExpression node) {
        return null;
    }

    public IValueReference visitObjectInitializer(ObjectInitializer node) {
        AnonymousValue result = new AnonymousValue();
        result.setDeclaredType(JSTypeSet.ref("Object"));
        for (ObjectInitializerPart part : node.getInitializers()) {
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            IValueReference child = this.extractNamedChild(result, pi.getName());
            IValueReference value = this.visit((ASTNode)pi.getValue());
            if (child == null) continue;
            child.setValue(value);
            child.setLocation(ReferenceLocation.create(this.getSource(), pi.getName().sourceStart(), pi.getName().sourceEnd()));
            if (child.getKind() != ReferenceKind.UNKNOWN) continue;
            child.setKind(ReferenceKind.FIELD);
        }
        return result;
    }

    public IValueReference visitParenthesizedExpression(ParenthesizedExpression node) {
        return this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitPropertyExpression(PropertyExpression node) {
        IValueReference object = this.visit((ASTNode)node.getObject());
        return this.extractNamedChild(object, node.getProperty());
    }

    protected IValueReference extractNamedChild(IValueReference parent, Expression name) {
        if (parent != null) {
            String nameStr;
            if (name instanceof Identifier) {
                IValueReference child;
                nameStr = ((Identifier)name).getName();
                IRType parentType = JavaScriptValidations.typeOf(parent);
                if (parentType != null && TypeInferencerVisitor.isXML(parentType) && (child = parent.getChild(nameStr)) != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(JSTypeSet.ref("XML"));
                    return child;
                }
            } else if (name instanceof StringLiteral) {
                nameStr = ((StringLiteral)name).getValue();
            } else if (name instanceof XmlAttributeIdentifier) {
                if (((XmlAttributeIdentifier)name).getExpression() instanceof AsteriskExpression) {
                    return this.visitAsteriskExpression((AsteriskExpression)((XmlAttributeIdentifier)name).getExpression());
                }
                nameStr = ((XmlAttributeIdentifier)name).getAttributeName();
                IValueReference child = parent.getChild(nameStr);
                if (child != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(JSTypeSet.ref("XML"));
                    return child;
                }
            } else {
                if (name instanceof AsteriskExpression) {
                    return this.visitAsteriskExpression((AsteriskExpression)name);
                }
                if (name instanceof ParenthesizedExpression) {
                    this.visitParenthesizedExpression((ParenthesizedExpression)name);
                    return parent;
                }
                return null;
            }
            return parent.getChild(nameStr);
        }
        return null;
    }

    public IValueReference visitRegExpLiteral(RegExpLiteral node) {
        return this.context.getFactory().createRegExp(this.peekContext());
    }

    public IValueReference visitReturnStatement(ReturnStatement node) {
        if (node.getValue() != null) {
            IValueReference returnValue;
            IValueReference value = this.visit((ASTNode)node.getValue());
            if (value != null && (returnValue = this.peekContext().getReturnValue()) != null) {
                returnValue.addValue(value, !(value instanceof LazyTypeReference));
            }
            return value;
        }
        return null;
    }

    public IValueReference visitScript(Script node) {
        this.handleDeclarations((JSScope)node);
        return (IValueReference)this.visit(node.getStatements());
    }

    private void handleDeclarations(JSScope scope) {
        for (JSDeclaration declaration : scope.getDeclarations()) {
            if (declaration instanceof FunctionStatement) continue;
            boolean cfr_ignored_0 = declaration instanceof VariableDeclaration;
        }
    }

    public IValueReference visitStatementBlock(StatementBlock node) {
        for (Statement statement : node.getStatements()) {
            this.visit((ASTNode)statement);
        }
        return null;
    }

    public IValueReference visitStringLiteral(StringLiteral node) {
        return this.context.getFactory().createString(this.peekContext());
    }

    public IValueReference visitSwitchStatement(SwitchStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        for (SwitchComponent component : node.getCaseClauses()) {
            if (component instanceof CaseClause) {
                this.visit((ASTNode)((CaseClause)component).getCondition());
            }
            this.visit(component.getStatements());
        }
        return null;
    }

    public IValueReference visitThisExpression(ThisExpression node) {
        return this.peekContext().getThis();
    }

    public IValueReference visitThrowStatement(ThrowStatement node) {
        if (node.getException() != null) {
            this.visit((ASTNode)node.getException());
        }
        return null;
    }

    public IValueReference visitTryStatement(TryStatement node) {
        this.visit((ASTNode)node.getBody());
        for (CatchClause catchClause : node.getCatches()) {
            NestedValueCollection collection = new NestedValueCollection(this.peekContext());
            IValueReference exception = collection.createChild(catchClause.getException().getName());
            exception.setDeclaredType(JSTypeSet.ref("Error"));
            this.enterContext(collection);
            if (catchClause.getStatement() != null) {
                this.visit((ASTNode)catchClause.getStatement());
            }
            this.leaveContext();
        }
        if (node.getFinally() != null) {
            this.visit((ASTNode)node.getFinally().getStatement());
        }
        return null;
    }

    public IValueReference visitUnaryOperation(UnaryOperation node) {
        if (node.getOperation() == 98) {
            this.visit((ASTNode)node.getExpression());
            return this.context.getFactory().createBoolean(this.peekContext());
        }
        if (node.getOperation() == 12) {
            IValueReference value = this.visit((ASTNode)node.getExpression());
            if (value != null) {
                value.delete();
            }
            return this.context.getFactory().createBoolean(this.peekContext());
        }
        if (node.getOperation() == 28) {
            this.visit((ASTNode)node.getExpression());
            return this.context.getFactory().createString(this.peekContext());
        }
        if (node.getOperation() == 30) {
            this.visit((ASTNode)node.getExpression());
            return null;
        }
        return this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitVariableStatement(VariableStatement node) {
        IValueCollection collection = this.peekContext();
        IValueReference result = null;
        for (VariableDeclaration declaration : node.getVariables()) {
            result = this.createVariable(collection, declaration);
        }
        return result;
    }

    public IValueReference visitVoidExpression(VoidExpression node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public IValueReference visitWhileStatement(WhileStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    public IValueReference visitWithStatement(WithStatement node) {
        IValueReference with = this.visit((ASTNode)node.getExpression());
        if (with != null) {
            WithValueCollection withCollection = new WithValueCollection(this.peekContext(), with);
            this.enterContext(withCollection);
            this.visit((ASTNode)node.getStatement());
            this.leaveContext();
        } else {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.docBuilder == null) {
            this.docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        return this.docBuilder;
    }

    public IValueReference visitXmlLiteral(XmlLiteral node) {
        IValueReference xmlValueReference = this.context.getFactory().createXML(this.peekContext());
        if (xmlValueReference instanceof IValueProvider) {
            IRType xmlType = JSTypeSet.ref(this.context.getKnownType("XML", null));
            IValue xmlValue = ((IValueProvider)((Object)xmlValueReference)).getValue();
            List fragments = node.getFragments();
            StringBuilder xml = new StringBuilder();
            for (XmlFragment xmlFragment : fragments) {
                if (xmlFragment instanceof XmlTextFragment) {
                    String xmlText = ((XmlTextFragment)xmlFragment).getXml();
                    if (xmlText.equals("<></>")) continue;
                    if (xmlText.startsWith("<>") && xmlText.endsWith("</>")) {
                        xmlText = "<xml>" + xmlText.substring(2, xmlText.length() - 3) + "</xml>";
                    }
                    xml.append(xmlText);
                    continue;
                }
                if (!(xmlFragment instanceof XmlExpressionFragment)) continue;
                Expression expression = ((XmlExpressionFragment)xmlFragment).getExpression();
                this.visit((ASTNode)expression);
                if (xml.charAt(xml.length() - 1) == '<' || xml.subSequence(xml.length() - 2, xml.length()).equals("</")) {
                    if (expression instanceof Identifier) {
                        xml.append(((Identifier)expression).getName());
                        continue;
                    }
                    xml.setLength(0);
                    break;
                }
                xml.append("\"\" ");
            }
            if (xml.length() > 0) {
                try {
                    DocumentBuilder docBuilder = this.getDocumentBuilder();
                    Document doc = docBuilder.parse(new InputSource(new StringReader(xml.toString())));
                    NodeList nl = doc.getChildNodes();
                    if (nl.getLength() == 1) {
                        Node item = nl.item(0);
                        NamedNodeMap attributes = item.getAttributes();
                        int a = 0;
                        while (a < attributes.getLength()) {
                            Node attribute = attributes.item(a);
                            xmlValue.createChild("@" + attribute.getNodeName(), 0);
                            ++a;
                        }
                        this.createXmlChilds(xmlType, xmlValue, item.getChildNodes());
                    } else {
                        System.err.println("root should be 1 child?? " + xml);
                    }
                }
                catch (Exception exception) {}
            }
        }
        return xmlValueReference;
    }

    private void createXmlChilds(IRType xmlType, IValue xmlValue, NodeList nl) {
        int i = 0;
        while (i < nl.getLength()) {
            String value;
            Node item = nl.item(i);
            if (item.getNodeType() != 3 || (value = item.getNodeValue()) != null && !"".equals(value.trim())) {
                IValue nodeValue = xmlValue.createChild(item.getNodeName(), 0);
                nodeValue.setDeclaredType(xmlType);
                NamedNodeMap attributes = item.getAttributes();
                if (attributes != null) {
                    int a = 0;
                    while (a < attributes.getLength()) {
                        Node attribute = attributes.item(a);
                        nodeValue.createChild("@" + attribute.getNodeName(), 0);
                        ++a;
                    }
                }
                this.createXmlChilds(xmlType, nodeValue, item.getChildNodes());
            }
            ++i;
        }
    }

    public IValueReference visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
        return this.context.getFactory().createXML(this.peekContext());
    }

    public IValueReference visitYieldOperator(YieldOperator node) {
        IValueReference reference;
        IValueReference value = this.visit((ASTNode)node.getExpression());
        if (value != null && (reference = this.peekContext().getReturnValue()) != null) {
            reference.addValue(value, true);
        }
        return null;
    }

    public static boolean isFunctionDeclaration(Expression expression) {
        PropertyExpression pe = null;
        if (expression instanceof PropertyExpression) {
            pe = (PropertyExpression)expression;
        } else if (expression.getParent() instanceof PropertyExpression) {
            pe = (PropertyExpression)expression.getParent();
        }
        if (pe != null && pe.getObject() instanceof ThisExpression && pe.getParent() instanceof BinaryOperation) {
            return ((BinaryOperation)pe.getParent()).getRightExpression() instanceof FunctionStatement;
        }
        return false;
    }

    protected static class AnonymousNewValue
    extends AnonymousValue {
        protected AnonymousNewValue() {
        }

        public IValueReference getChild(String name) {
            if (name.equals("()")) {
                return this;
            }
            return super.getChild(name);
        }
    }

    private class Branching {
        private Branching() {
        }

        public void end() {
            TypeInferencerVisitor.this.branchings.remove(this);
        }
    }

    private static class Capture {
        final TypeVariable variable;
        final JSTypeSet types;

        public Capture(TypeVariable variable, JSTypeSet types) {
            this.variable = variable;
            this.types = types;
        }
    }

    public static class VisitNewResult {
        IValueReference typeValue;
        IValueReference[] arguments;
        IValueReference value;

        public IValueReference getValue() {
            return this.value;
        }

        public IValueReference getTypeValue() {
            return this.typeValue;
        }

        public IValueReference[] getArguments() {
            return this.arguments;
        }
    }
}

