/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestorKind;
import org.eclipse.dltk.internal.javascript.parser.structure.Declaration;
import org.eclipse.dltk.internal.javascript.parser.structure.FieldDeclaration;
import org.eclipse.dltk.internal.javascript.parser.structure.MethodDeclaration;
import org.eclipse.dltk.internal.javascript.parser.structure.MethodRef;
import org.eclipse.dltk.internal.javascript.parser.structure.ReferenceIterator;
import org.eclipse.dltk.internal.javascript.parser.structure.ReferenceKey;
import org.eclipse.dltk.internal.javascript.parser.structure.ReferenceSet;
import org.eclipse.dltk.internal.javascript.parser.structure.VarDeclaration;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueParent;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureReporter
extends TypeInferencerVisitor {
    private final ReferenceSet referenceSet = new ReferenceSet();
    private final Set<IValueReference> processed = new HashSet<IValueReference>();
    final ISourceElementRequestor fRequestor;
    private ReferenceIterator iterator;
    final boolean isIndexing;

    @Override
    public IValueReference visitCallExpression(CallExpression node) {
        this.reportMethodRef((ASTNode)node.getExpression(), node.getArguments().size());
        return super.visitCallExpression(node);
    }

    private void reportMethodRef(ASTNode expression, int argCount) {
        if (expression instanceof Identifier) {
            Identifier id = (Identifier)expression;
            this.referenceSet.add(id.getName(), id.sourceStart(), id.sourceEnd(), new MethodRef(argCount));
        } else if (expression instanceof PropertyExpression) {
            this.reportMethodRef((ASTNode)((PropertyExpression)expression).getProperty(), argCount);
        }
    }

    @Override
    public IValueReference visitIdentifier(Identifier node) {
        IValueReference result = super.visitIdentifier(node);
        if (result != null && result.getKind() != ReferenceKind.LOCAL || !this.inFunction()) {
            this.reportFieldRef(node);
        }
        return result;
    }

    @Override
    protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
        if (this.isIndexing) {
            Identifier node = declaration.getIdentifier();
            this.referenceSet.add(node.getName(), node.sourceStart(), node.sourceEnd(), new VarDeclaration(declaration.sourceStart(), declaration.sourceEnd()));
        }
        return super.createVariable(context, declaration);
    }

    @Override
    public IValueReference visitPropertyExpression(PropertyExpression node) {
        if (node.getProperty() instanceof Identifier) {
            this.reportFieldRef((Identifier)node.getProperty());
        }
        return super.visitPropertyExpression(node);
    }

    private void reportFieldRef(Identifier node) {
        this.referenceSet.add(node.getName(), node.sourceStart(), node.sourceEnd());
    }

    public StructureReporter(ITypeInferenceContext context, ISourceElementRequestor requestor) {
        super(context);
        this.fRequestor = requestor;
        this.isIndexing = SourceElementRequestorKind.INDEXER.matches(this.fRequestor);
    }

    public void processScope(IValueParent collection, boolean allowFields) {
        ArrayList<Declaration> children = new ArrayList<Declaration>();
        for (String childName : collection.getDirectChildren()) {
            IValueReference child = collection.getChild(childName);
            if (child == null || !this.processed.add(child) || child.getLocation() != null && child.getLocation().getSourceModule() != this.context.getSource().getSourceModule()) continue;
            if (child.getKind() == ReferenceKind.LOCAL || child.getKind() == ReferenceKind.FIELD || child.getKind() == ReferenceKind.GLOBAL) {
                children.add(new FieldDeclaration(childName, child));
                continue;
            }
            if (child.getKind() != ReferenceKind.FUNCTION && !child.hasChild("()")) continue;
            children.add(new MethodDeclaration(childName, child));
        }
        if (!children.isEmpty()) {
            Collections.sort(children);
            for (Declaration declaration : children) {
                declaration.report(this, allowFields);
            }
        }
    }

    public void reportRefs(int position) {
        while (this.iterator.hasNext()) {
            ReferenceKey current = this.iterator.current();
            if (current.start >= position && position != Integer.MAX_VALUE) break;
            this.reportRef(current, this.iterator.getValues());
            this.iterator.moveNext();
        }
    }

    private void reportRef(ReferenceKey current, List<Object> values) {
        if (values.contains(Boolean.FALSE)) {
            return;
        }
        boolean processed = false;
        for (Object value : values) {
            if (value instanceof MethodRef) {
                processed = true;
                this.fRequestor.acceptMethodReference(current.name, ((MethodRef)value).argCount, current.start, current.end);
                continue;
            }
            if (!(value instanceof VarDeclaration)) continue;
            processed = true;
            VarDeclaration varDecl = (VarDeclaration)value;
            IElementRequestor.FieldInfo fi = new IElementRequestor.FieldInfo();
            fi.name = current.name;
            fi.declarationStart = varDecl.sourceStart;
            fi.nameSourceStart = current.start;
            fi.nameSourceEnd = current.end;
            this.fRequestor.enterField(fi);
            this.fRequestor.exitField(varDecl.sourceEnd);
        }
        if (!processed) {
            this.fRequestor.acceptFieldReference(current.name, current.start);
        }
    }

    void removeReference(String name, int start, int end) {
        this.iterator.remove(name, start, end);
    }

    public void beginReporting() {
        this.fRequestor.enterModule();
        this.iterator = this.referenceSet.iterator();
    }

    public void endReporting(int end) {
        this.reportRefs(Integer.MAX_VALUE);
        this.fRequestor.exitModule(end);
    }
}

