/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.builder.State;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.wizards.ILocationGroup;

public class ProjectWizardUtils {
    static final String FILENAME_PROJECT = ".project";
    static final String FILENAME_BUILDPATH = ".buildpath";

    public static void reuseInterpreterLibraries(IProject fCurrProject, IInterpreterInstall projectInterpreter, IProgressMonitor monitor) throws CoreException {
        State lastState = (State)ModelManager.getModelManager().getLastBuiltState(fCurrProject, monitor);
        if (lastState == null) {
            lastState = new State(fCurrProject);
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            State state;
            IScriptProject scriptProject;
            IInterpreterInstall install;
            if (projects[i].isAccessible() && DLTKLanguageManager.hasScriptNature((IProject)projects[i]) && projectInterpreter.equals(install = ScriptRuntime.getInterpreterInstall((IScriptProject)(scriptProject = DLTKCore.create((IProject)projects[i])))) && (state = (State)ModelManager.getModelManager().getLastBuiltState(projects[i], monitor)) != null) {
                lastState.getExternalFolders().addAll(state.getExternalFolders());
            }
            ++i;
        }
        lastState.setNoCleanExternalFolders();
        ModelManager.getModelManager().setLastBuiltState(fCurrProject, (Object)lastState);
    }

    static List getDefaultBuildpathEntry(ILocationGroup firstPage) {
        IBuildpathEntry defaultPath = ScriptRuntime.getDefaultInterpreterContainerEntry();
        Path InterpreterEnvironmentContainerPath = new Path(ScriptRuntime.INTERPRETER_CONTAINER);
        IInterpreterInstall inst = firstPage.getSelectedInterpreter();
        if (inst != null) {
            IPath newPath = InterpreterEnvironmentContainerPath.append(inst.getInterpreterInstallType().getId()).append(inst.getName());
            return Collections.singletonList(DLTKCore.newContainerEntry((IPath)newPath));
        }
        if (defaultPath != null) {
            return Collections.singletonList(defaultPath);
        }
        return Collections.EMPTY_LIST;
    }
}

