/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.AbstractScriptBreakpoint;

public class ScriptLineBreakpoint
extends AbstractScriptBreakpoint
implements IScriptLineBreakpoint {
    private static final String[] UPDATABLE_ATTRS = new String[]{"lineNumber", "org.eclipse.debug.core.enabled", "org.eclipse.dltk.debug.hit_condition", "org.eclipse.dltk.debug.hit_value", "org.eclipse.dltk.debug.expression", "org.eclipse.dltk.debug.expression.state"};

    protected String getMarkerId() {
        return "org.eclipse.dltk.debug.scriptLineBreakpointMarker";
    }

    protected void addLineBreakpointAttributes(Map attributes, IPath path, int lineNumber, int charStart, int charEnd) {
        if (path != null) {
            attributes.put("location", path.toPortableString());
        }
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
    }

    public ScriptLineBreakpoint() {
    }

    public ScriptLineBreakpoint(final String debugModelId, final IResource resource, final IPath path, final int lineNumber, final int charStart, final int charEnd, final boolean add) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ScriptLineBreakpoint.this.setMarker(resource.createMarker(ScriptLineBreakpoint.this.getMarkerId()));
                HashMap attributes = new HashMap();
                ScriptLineBreakpoint.this.addScriptBreakpointAttributes(attributes, debugModelId, true);
                ScriptLineBreakpoint.this.addLineBreakpointAttributes(attributes, path, lineNumber, charStart, charEnd);
                ScriptLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                ScriptLineBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public String getResourceName() throws CoreException {
        IResource resource = this.ensureMarker().getResource();
        if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
            return resource.getName();
        }
        String portablePath = (String)this.ensureMarker().getAttribute("location");
        if (portablePath != null) {
            IPath path = Path.fromPortableString((String)portablePath);
            return path.lastSegment();
        }
        return null;
    }

    public IResource getResource() {
        try {
            IResource resource = this.ensureMarker().getResource();
            if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
                return resource;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IPath getResourcePath() {
        try {
            IResource resource = this.ensureMarker().getResource();
            if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
                return this.ensureMarker().getResource().getFullPath();
            }
            String path = (String)this.ensureMarker().getAttribute("location");
            if (path != null) {
                return Path.fromPortableString((String)path);
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    public URI getResourceURI() {
        try {
            IResource resource = this.ensureMarker().getResource();
            if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
                return ScriptLineBreakpoint.makeUri((IPath)new Path(this.ensureMarker().getResource().getLocationURI().getPath()));
            }
            String portablePath = (String)this.ensureMarker().getAttribute("location");
            if (portablePath != null) {
                IPath path = Path.fromPortableString((String)portablePath);
                return ScriptLineBreakpoint.makeUri(path);
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    public String[] getUpdatableAttributes() {
        return UPDATABLE_ATTRS;
    }
}

