/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.antlr.runtime.Token;
import org.eclipse.core.runtime.Assert;

public class JavaScriptToken
implements Token {
    private int channel;
    private int charPositionInLine;
    private int lineno;
    private String text;
    private int tokenIndex;
    private int ttype;

    public JavaScriptToken(Token source) {
        this.channel = source.getChannel();
        this.charPositionInLine = source.getCharPositionInLine();
        this.lineno = source.getLine();
        this.text = source.getText();
        this.tokenIndex = source.getTokenIndex();
        this.ttype = source.getType();
    }

    public JavaScriptToken() {
    }

    public int getChannel() {
        return this.channel;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public int getLine() {
        return this.lineno;
    }

    public String getText() {
        return this.text;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public int getType() {
        return this.ttype;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public void setCharPositionInLine(int pos) {
        this.charPositionInLine = pos;
    }

    public void setLine(int line) {
        this.lineno = line;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTokenIndex(int index) {
        this.tokenIndex = index;
        Assert.isTrue((this.tokenIndex >= 0 ? 1 : 0) != 0);
    }

    public void setType(int ttype) {
        this.ttype = ttype;
    }

    public String toString() {
        return this.getText();
    }
}

