/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.UIModelProviderManager;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IModelCompareCategories;
import org.eclipse.dltk.ui.IModelCompareProvider;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ModelElementSorter
extends ViewerSorter
implements IModelCompareCategories {
    private MembersOrderPreferenceCache fMemberOrderCache = DLTKUIPlugin.getDefault().getMemberOrderPreferenceCache();
    private Collator fNewCollator = null;
    private boolean innerElements = true;

    public ModelElementSorter() {
        super(null);
    }

    public boolean isInnerElements() {
        return this.innerElements;
    }

    public void setInnerElements(boolean innerElements) {
        this.innerElements = innerElements;
    }

    public int category(Object element) {
        IModelCompareProvider[] providers = this.getCompareProviders(element);
        int i = 0;
        while (i < providers.length) {
            IModelCompareProvider.CompareResult category = providers[i].category(element);
            if (category != null) {
                return category.result;
            }
            ++i;
        }
        if (element instanceof IModelElement) {
            block21: {
                try {
                    IModelElement je = (IModelElement)element;
                    switch (je.getElementType()) {
                        case 9: {
                            IMethod method = (IMethod)je;
                            if (method.isConstructor()) {
                                return this.getMemberCategory(1);
                            }
                            return this.getMemberCategory(2);
                        }
                        case 8: {
                            return this.getMemberCategory(3);
                        }
                        case 7: {
                            return this.getMemberCategory(0);
                        }
                        case 10: {
                            return 9;
                        }
                        case 4: {
                            return 4;
                        }
                        case 3: {
                            return 2;
                        }
                        case 2: {
                            return 1;
                        }
                        case 5: {
                            return 5;
                        }
                    }
                }
                catch (ModelException e) {
                    if (e.isDoesNotExist()) break block21;
                    DLTKUIPlugin.log(e);
                }
            }
            return 50;
        }
        if (element instanceof IFile) {
            return 7;
        }
        if (element instanceof IProject) {
            return 1;
        }
        if (element instanceof IContainer) {
            return 6;
        }
        if (element instanceof IStorage) {
            return 8;
        }
        if (element instanceof BuildPathContainer) {
            return 60;
        }
        return 51;
    }

    private IModelCompareProvider[] getCompareProviders(Object element) {
        IDLTKLanguageToolkit tk;
        String toolkit = null;
        if (element instanceof IModelElement && (tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)element))) != null) {
            toolkit = tk.getNatureId();
        }
        IModelCompareProvider[] providers = UIModelProviderManager.getCompareProviders(toolkit);
        return providers;
    }

    private IModelCompareProvider[] getCompareProviders(Object element, Object element2) {
        IDLTKLanguageToolkit tk;
        String toolkit1 = null;
        String toolkit2 = null;
        if (element instanceof IModelElement && (tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)element))) != null) {
            toolkit1 = tk.getNatureId();
        }
        if (element2 instanceof IModelElement && (tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)element2))) != null) {
            toolkit2 = tk.getNatureId();
        }
        if (toolkit1 == null || toolkit2 == null) {
            return UIModelProviderManager.getCompareProviders(null);
        }
        if (toolkit1 != toolkit2) {
            IModelCompareProvider[] tk1 = UIModelProviderManager.getCompareProviders(toolkit1);
            IModelCompareProvider[] tk2 = UIModelProviderManager.getCompareProviders(toolkit1);
            HashSet result = new HashSet();
            result.addAll(Arrays.asList(tk1));
            result.addAll(Arrays.asList(tk2));
            return result.toArray(new IModelCompareProvider[result.size()]);
        }
        return UIModelProviderManager.getCompareProviders(toolkit1);
    }

    private int getMemberCategory(int kind) {
        int offset = this.fMemberOrderCache.getCategoryIndex(kind);
        return offset + 10;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cmp;
        IModelElement me;
        String name2;
        int cat1 = this.category(e1);
        int cat2 = this.category(e2);
        IModelCompareProvider[] providers = this.getCompareProviders(e1);
        int i = 0;
        while (i < providers.length) {
            IModelCompareProvider.CompareResult category = providers[i].compare(e1, e2, cat1, cat2);
            if (category != null) {
                return category.result;
            }
            ++i;
        }
        if (this.needsBuildpathComparision(e1, cat1, e2, cat2)) {
            int p2;
            int p1;
            IProjectFragment root1 = this.getProjectFragment(e1);
            IProjectFragment root2 = this.getProjectFragment(e2);
            if (root1 == null) {
                if (root2 == null) {
                    return 0;
                }
                return 1;
            }
            if (root2 == null) {
                return -1;
            }
            if (!root1.getPath().equals((Object)root2.getPath()) && (p1 = this.getBuildpathIndex(root1)) != (p2 = this.getBuildpathIndex(root2))) {
                return p1 - p2;
            }
        }
        if (cat1 != cat2) {
            return cat1 - cat2;
        }
        if (cat1 == 1 || cat1 == 7 || cat1 == 6 || cat1 == 8 || cat1 == 51) {
            String name1 = this.getNonScriptElementLabel(viewer, e1);
            name2 = this.getNonScriptElementLabel(viewer, e2);
            if (name1 != null && name2 != null) {
                return this.getNewCollator().compare(name1, name2);
            }
            return 0;
        }
        String name1 = this.getElementName(e1);
        name2 = this.getElementName(e2);
        if (!this.isInnerElements() && e1 instanceof IModelElement && (me = (IModelElement)e1).getElementType() > 6) {
            return 0;
        }
        if (e1 instanceof IType && e2 instanceof IType) {
            if (name1.length() == 0) {
                if (name2.length() == 0) {
                    try {
                        String[] sc1 = ((IType)e1).getSuperClasses();
                        String[] sc2 = ((IType)e2).getSuperClasses();
                        if (sc1 != null && sc2 != null && sc1.length > 0 && sc2.length > 0) {
                            return this.getNewCollator().compare(sc1[0], sc2[0]);
                        }
                        return 0;
                    }
                    catch (ModelException modelException) {
                        return 0;
                    }
                }
                return 1;
            }
            if (name2.length() == 0) {
                return -1;
            }
        }
        if ((cmp = this.getNewCollator().compare(name1, name2)) != 0) {
            return cmp;
        }
        if (e1 instanceof IMethod && e2 instanceof IMethod) {
            String[] params2;
            String[] params1;
            block27: {
                params1 = null;
                try {
                    params1 = ((IMethod)e1).getParameters();
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
                params2 = null;
                try {
                    params2 = ((IMethod)e2).getParameters();
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block27;
                    e.printStackTrace();
                }
            }
            if (params1 != null && params2 != null) {
                int len = Math.min(params1.length, params2.length);
                int i2 = 0;
                while (i2 < len) {
                    cmp = this.getNewCollator().compare(params1[i2], params2[i2]);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i2;
                }
            }
            return params1.length - params2.length;
        }
        return 0;
    }

    private IProjectFragment getProjectFragment(Object element) {
        if (element instanceof BuildPathContainer) {
            BuildPathContainer cp = (BuildPathContainer)element;
            IProjectFragment[] roots = cp.getProjectFragments();
            if (roots.length > 0) {
                return roots[0];
            }
            return null;
        }
        return ScriptModelUtil.getProjectFragment((IModelElement)((IModelElement)element));
    }

    private String getNonScriptElementLabel(Viewer viewer, Object element) {
        IBaseLabelProvider prov;
        IWorkbenchAdapter adapter;
        if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            return adapter.getLabel(element);
        }
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)prov).getText(element);
        }
        return null;
    }

    private int getBuildpathIndex(IProjectFragment root) {
        try {
            IPath rootPath = root.getPath();
            IProjectFragment[] roots = root.getScriptProject().getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getPath().equals((Object)rootPath)) {
                    return i;
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return Integer.MAX_VALUE;
    }

    private final Comparator getNewCollator() {
        if (this.fNewCollator == null) {
            this.fNewCollator = Collator.getInstance();
        }
        return this.fNewCollator;
    }

    private boolean needsBuildpathComparision(Object e1, int cat1, Object e2, int cat2) {
        if (cat1 == 2 && cat2 == 2 || cat1 == 60 && cat2 == 60 || cat1 == 4 && ((IScriptFolder)e1).getParent().getResource() instanceof IProject && cat2 == 2 || cat1 == 2 && cat2 == 4 && ((IScriptFolder)e2).getParent().getResource() instanceof IProject) {
            IScriptProject p1 = this.getScriptProject(e1);
            return p1 != null && p1.equals(this.getScriptProject(e2));
        }
        return false;
    }

    private IScriptProject getScriptProject(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getScriptProject();
        }
        if (element instanceof BuildPathContainer) {
            return ((BuildPathContainer)element).getScriptProject();
        }
        return null;
    }

    protected String getElementName(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getElementName();
        }
        if (element instanceof BuildPathContainer) {
            return ((BuildPathContainer)element).getLabel();
        }
        return element.toString();
    }
}

