/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui.popup.actions;

import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.ui.actions.AbstractMenuCreatorObjectActionDelegate;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.ui.popup.actions.RemoveAllMarkersAction;
import org.eclipse.dltk.validators.internal.ui.popup.actions.ValidateAction;
import org.eclipse.dltk.validators.internal.ui.popup.actions.ValidateAllAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DLTKValidatorsModelElementAction
extends AbstractMenuCreatorObjectActionDelegate {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void fillMenu(AbstractMenuCreatorObjectActionDelegate.IMenuBuilder menu, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IModelElement)) {
            return;
        }
        IModelElement element = (IModelElement)input;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (toolkit == null) {
            return;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)element);
        if (environment == null) {
            return;
        }
        IValidatorType[] validatorTypes = ValidatorRuntime.getValidatorTypes((String)toolkit.getNatureId());
        if (validatorTypes == null || validatorTypes.length == 0) {
            return;
        }
        int validatorCount = 0;
        int i = 0;
        while (i < validatorTypes.length) {
            IValidator[] validators;
            IValidatorType type = validatorTypes[i];
            if (DLTKValidatorsModelElementAction.isSupported(type) && (validators = type.getAllValidators(element.getScriptProject().getProject())) != null && validators.length != 0) {
                int j = 0;
                while (j < validators.length) {
                    IValidator validator = validators[j];
                    menu.addAction((IAction)new ValidateAction(validator, selection));
                    ++validatorCount;
                    ++j;
                }
            }
            ++i;
        }
        if (validatorCount != 0) {
            menu.addSeparator();
        }
        menu.addAction((IAction)new RemoveAllMarkersAction(selection));
        if (validatorCount != 0) {
            menu.addAction((IAction)new ValidateAllAction(selection));
        }
    }

    private static boolean isSupported(IValidatorType type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.validators.core.ISourceModuleValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!type.supports((Class)clazz)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.dltk.validators.core.IResourceValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!type.supports((Class)clazz2)) {
                return false;
            }
        }
        return true;
    }
}

