/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterContainerHelper {
    private static final char SEPARATOR = '|';
    private static final String PACKAGES_ATTR = "user_dependencies";
    private static final String PACKAGES_AUTO_ATTR = "auto_dependencies";
    public static final String CONTAINER_PATH = ScriptRuntime.INTERPRETER_CONTAINER;

    public static void getInterpreterContainerDependencies(IScriptProject project, Set packages, Set autoPackages) {
        IBuildpathEntry[] rawBuildpath;
        block12: {
            rawBuildpath = null;
            try {
                rawBuildpath = project.getRawBuildpath();
            }
            catch (ModelException e1) {
                if (!DLTKCore.DEBUG) break block12;
                e1.printStackTrace();
            }
        }
        if (rawBuildpath == null) {
            return;
        }
        IBuildpathEntry containerEntry = null;
        int i = 0;
        while (i < rawBuildpath.length) {
            if (rawBuildpath[i].getPath().segment(0).equals(CONTAINER_PATH)) {
                containerEntry = rawBuildpath[i];
            }
            ++i;
        }
        if (containerEntry == null) {
            return;
        }
        IBuildpathAttribute[] extraAttributes = containerEntry.getExtraAttributes();
        int i2 = 0;
        while (i2 < extraAttributes.length) {
            int j;
            String[] split;
            String value;
            if (extraAttributes[i2].getName().equals(PACKAGES_ATTR)) {
                value = extraAttributes[i2].getValue();
                split = InterpreterContainerHelper.split(value);
                j = 0;
                while (j < split.length) {
                    packages.add(split[j]);
                    ++j;
                }
            } else if (extraAttributes[i2].getName().equals(PACKAGES_AUTO_ATTR)) {
                value = extraAttributes[i2].getValue();
                split = InterpreterContainerHelper.split(value);
                j = 0;
                while (j < split.length) {
                    autoPackages.add(split[j]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    private static String[] split(String value) {
        String sub;
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < value.length()) {
            if (value.charAt(i) == '|' && start < end) {
                String sub2 = value.substring(start, end);
                if (sub2.length() > 0) {
                    result.add(sub2);
                }
                start = end + 1;
            }
            ++end;
            ++i;
        }
        if (start < end && (sub = value.substring(start, end)).length() > 0) {
            result.add(sub);
        }
        return result.toArray(new String[result.size()]);
    }

    public static void setInterpreterContainerDependencies(IScriptProject project, Set packages, Set autoPackages) {
        block9: {
            IBuildpathEntry[] rawBuildpath;
            block8: {
                rawBuildpath = null;
                try {
                    rawBuildpath = project.getRawBuildpath();
                }
                catch (ModelException e1) {
                    if (!DLTKCore.DEBUG) break block8;
                    e1.printStackTrace();
                }
            }
            IPath containerName = new Path(CONTAINER_PATH).append(project.getElementName());
            ArrayList<IBuildpathEntry> newBuildpath = new ArrayList<IBuildpathEntry>();
            boolean found = false;
            int i = 0;
            while (i < rawBuildpath.length) {
                if (!rawBuildpath[i].getPath().segment(0).equals(CONTAINER_PATH)) {
                    newBuildpath.add(rawBuildpath[i]);
                } else {
                    found = true;
                    newBuildpath.add(InterpreterContainerHelper.createPackagesContainer(packages, autoPackages, rawBuildpath[i].getPath()));
                }
                ++i;
            }
            if (!found) {
                newBuildpath.add(InterpreterContainerHelper.createPackagesContainer(packages, autoPackages, containerName));
            }
            IBuildpathEntry[] nbp = newBuildpath.toArray(new IBuildpathEntry[newBuildpath.size()]);
            try {
                project.setRawBuildpath(nbp, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
    }

    public static IBuildpathEntry createPackagesContainer(Set names, Set autoPackages, IPath containerName) {
        String pkgs = InterpreterContainerHelper.pkgsToString(names);
        String autoPkgs = InterpreterContainerHelper.pkgsToString(autoPackages);
        IBuildpathAttribute attr = DLTKCore.newBuildpathAttribute((String)PACKAGES_ATTR, (String)pkgs);
        IBuildpathAttribute attr2 = DLTKCore.newBuildpathAttribute((String)PACKAGES_AUTO_ATTR, (String)autoPkgs);
        IBuildpathEntry container = DLTKCore.newContainerEntry((IPath)containerName, (IAccessRule[])BuildpathEntry.NO_ACCESS_RULES, (IBuildpathAttribute[])new IBuildpathAttribute[]{attr, attr2}, (boolean)false);
        return container;
    }

    private static String pkgsToString(Set names) {
        StringBuffer buffer = new StringBuffer();
        Object[] array = names.toArray();
        int i = 0;
        while (i < array.length) {
            buffer.append((String)array[i]);
            if (i != array.length - 1) {
                buffer.append('|');
            }
            ++i;
        }
        return buffer.toString();
    }
}

