/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug.ui.console;

import org.eclipse.dltk.ruby.internal.debug.ui.console.RubyFileHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class RubyConsoleTracker
implements IPatternMatchListenerDelegate {
    private TextConsole fConsole;

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            RubyFileHyperlink link;
            String from_;
            int offset = event.getOffset();
            int length = event.getLength();
            IDocument document = this.getConsole().getDocument();
            String text = document.get(offset, length);
            if (text.indexOf("from -e") != -1) {
                return;
            }
            String trim = text.trim();
            if (trim.startsWith(from_ = "from ")) {
                int shift = text.indexOf(from_) + from_.length();
                offset += shift;
                length -= shift;
            }
            if ((link = new RubyFileHyperlink(this.fConsole)).isCorrect(offset, length)) {
                this.fConsole.addHyperlink((IHyperlink)link, offset, length);
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

