/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.rules;

import org.eclipse.dltk.tcl.internal.parsers.raw.CodeScanner;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parsers.raw.VariableSubstitution;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TclVariableRule
implements IRule {
    private IToken token;

    public TclVariableRule(IToken token) {
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        SkipCodeScanner scs = new SkipCodeScanner(scanner);
        if (!VariableSubstitution.iAm((CodeScanner)scs)) {
            return Token.UNDEFINED;
        }
        VariableSubstitution vs = new VariableSubstitution();
        try {
            vs.readMe((CodeScanner)scs);
        }
        catch (TclParseException tclParseException) {
            return Token.UNDEFINED;
        }
        return this.token;
    }

    private class SkipCodeScanner
    extends CodeScanner {
        ICharacterScanner scanner;

        public SkipCodeScanner(ICharacterScanner scanner) {
            super(null);
            this.scanner = scanner;
        }

        public int read() {
            return this.scanner.read();
        }

        public boolean isEOF() {
            int res = this.scanner.read();
            if (res == -1) {
                return true;
            }
            this.scanner.unread();
            return false;
        }

        public void unread() {
            this.scanner.unread();
        }

        public int getPosition() {
            return this.scanner.getColumn();
        }
    }
}

