/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import java.io.File;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.internal.core.search.processing.JobManager;
import org.eclipse.dltk.internal.core.util.Util;

public class DLTKSearchDocument
extends SearchDocument {
    private IFile file;
    protected byte[] byteContents;
    protected String charContents;
    private boolean external;

    public DLTKSearchDocument(String documentPath, SearchParticipant participant, boolean external) {
        super(documentPath, participant);
        this.external = external;
    }

    public DLTKSearchDocument(ZipEntry zipEntry, IPath zipFilePath, byte[] contents, SearchParticipant participant) {
        super(zipFilePath + "|" + zipEntry.getName(), participant);
        this.byteContents = contents;
    }

    public DLTKSearchDocument(String path, IPath containerPath, char[] contents, SearchParticipant participant, boolean external) {
        super("|" + path, participant);
        this.charContents = new String(contents);
        this.external = external;
    }

    public String getContents() {
        char[] contents = this.getCharContents();
        if (contents == null) {
            return "";
        }
        String ret = new String(contents);
        return ret;
    }

    public char[] getCharContents() {
        block8: {
            if (this.charContents != null) {
                return this.charContents.toCharArray();
            }
            try {
                if (this.external) break block8;
                IFile file = this.getFile();
                if (file.exists()) {
                    return Util.getResourceContentsAsCharArray(file);
                }
                File ffile = new File(this.getPath());
                if (ffile != null && ffile.exists()) {
                    return Util.getResourceContentsAsCharArray(ffile);
                }
                return null;
            }
            catch (ModelException e) {
                if (BasicSearchEngine.VERBOSE || JobManager.VERBOSE) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        File ffile = new File(this.getPath());
        if (ffile != null && ffile.exists()) {
            return Util.getResourceContentsAsCharArray(ffile);
        }
        return null;
    }

    public String getEncoding() {
        IFile resource;
        if (!this.external && (resource = this.getFile()) != null) {
            try {
                return resource.getCharset();
            }
            catch (CoreException coreException) {
                try {
                    return ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
                }
                catch (CoreException coreException2) {}
            }
        }
        return null;
    }

    private IFile getFile() {
        if (!this.external && this.file == null) {
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getPath()));
        }
        return this.file;
    }

    public String toString() {
        return "SearchDocument for " + this.getPath();
    }

    public boolean isExternal() {
        return this.external;
    }
}

