/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dltk.dbgp.internal.utils.Base64Helper;

public class DbgpRequest {
    private final Map options;
    private final String command;
    private String data;

    public DbgpRequest(String command) {
        this.command = command;
        this.options = new HashMap();
    }

    public String getCommand() {
        return this.command;
    }

    public void addOption(String optionNmae, int optionValue) {
        this.addOption(optionNmae, new Integer(optionValue));
    }

    public void addOption(String optionName, Object optionValue) {
        if (optionValue == null) {
            throw new IllegalArgumentException();
        }
        this.options.put(optionName, optionValue.toString());
    }

    public String getOption(String optionName) {
        return (String)this.options.get(optionName);
    }

    public boolean hasOption(String optionName) {
        return this.options.containsKey(optionName);
    }

    public int optionCount() {
        return this.options.size();
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.command);
        Iterator it = this.options.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(' ');
            sb.append(entry.getKey());
            sb.append(' ');
            sb.append(entry.getValue());
        }
        if (this.data != null) {
            sb.append(" -- ");
            sb.append(Base64Helper.encodeString(this.data));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof DbgpRequest) {
            DbgpRequest request = (DbgpRequest)o;
            return this.command.equals(request.command) && this.options.equals(request.options) && (this.data == null || this.data.equals(request.data));
        }
        return false;
    }
}

