/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.ModelException;

public class ExternalEntryFile
extends PlatformObject
implements IStorage {
    private IPath path;

    public ExternalEntryFile(IPath path) {
        this.path = path;
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.path.toOSString());
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "ExternalEntryFile[" + this.path.toOSString() + "]";
    }
}

