/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

public class CreateCopyOfSourceModuleChange
extends CreateTextFileChange {
    private ISourceModule fOldCu;
    private INewNameQuery fNameQuery;
    static /* synthetic */ Class class$0;

    public CreateCopyOfSourceModuleChange(IPath path, String source, ISourceModule oldCu, INewNameQuery nameQuery) {
        super(path, source, null, "java");
        this.fOldCu = oldCu;
        this.fNameQuery = nameQuery;
        this.setEncoding(oldCu);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ISourceModule unit = this.fOldCu;
        ResourceMapping mapping = DLTKElementResourceMapping.create(unit);
        Change result = super.perform(pm);
        this.markAsExecuted(unit, mapping);
        return result;
    }

    private void setEncoding(ISourceModule cunit) {
        IResource resource = cunit.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        try {
            String encoding = file.getCharset(false);
            if (encoding != null) {
                this.setEncoding(encoding, true);
            } else {
                encoding = file.getCharset(true);
                if (encoding != null) {
                    this.setEncoding(encoding, false);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected IFile getOldFile(IProgressMonitor pm) {
        pm.beginTask("", 10);
        String oldSource = super.getSource();
        IPath oldPath = super.getPath();
        String newTypeName = this.fNameQuery.getNewName();
        try {
            String newSource = CreateCopyOfSourceModuleChange.getCopiedFileSource((IProgressMonitor)new SubProgressMonitor(pm, 9), this.fOldCu, newTypeName);
            this.setSource(newSource);
            this.setPath(this.constructNewPath(newTypeName));
            return super.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        catch (CoreException coreException) {
            this.setSource(oldSource);
            this.setPath(oldPath);
            return super.getOldFile(pm);
        }
    }

    private IPath constructNewPath(String newTypeName) {
        String newCUName = ScriptModelUtil.getRenamedCUName((ISourceModule)this.fOldCu, (String)newTypeName);
        return ResourceUtil.getResource(this.fOldCu).getParent().getFullPath().append(newCUName);
    }

    private static String getCopiedFileSource(IProgressMonitor pm, ISourceModule cu, String newTypeName) throws CoreException {
        String string;
        ISourceModule wc = cu.getPrimary().getWorkingCopy(null);
        try {
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: CreateCopyOfSourceModuleChange add content pewview...");
            }
            string = wc.getSource();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            wc.discardWorkingCopy();
            throw throwable;
        }
        wc.discardWorkingCopy();
        return string;
    }

    private void markAsExecuted(ISourceModule unit, ResourceMapping mapping) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)unit);
            log.markAsProcessed((Object)mapping);
        }
    }
}

