/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import java.util.Locale;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleRelation;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessible2;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleRelation;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.internal.ole.win32.COM;

public class InternalAccessible2
implements Accessible2 {
    private IAccessible2 ia2 = null;

    public InternalAccessible2(IAccessible2 iAccessible2) {
        this.ia2 = iAccessible2;
    }

    public void dispose() {
        this.ia2 = null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public int getAccessibleRelationCount() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_nRelations(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public AccessibleRelation getAccessibleRelation(int n) {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_relation(n, nativeIntAccess.getAddress()) == 0) {
                    InternalAccessibleRelation internalAccessibleRelation = new InternalAccessibleRelation(nativeIntAccess.getInt());
                    return internalAccessibleRelation;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public AccessibleRelation[] getAccessibleRelations(int n) {
        if (this.ia2 != null && n > 0) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(n + 1);
            try {
                if (this.ia2.get_relations(n, nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(0)) == 0) {
                    int n2 = nativeIntAccess.getInt(0);
                    AccessibleRelation[] accessibleRelationArray = new AccessibleRelation[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        accessibleRelationArray[n3] = new InternalAccessibleRelation(nativeIntAccess.getInt(n3 + 1));
                        ++n3;
                    }
                    AccessibleRelation[] accessibleRelationArray2 = accessibleRelationArray;
                    return accessibleRelationArray2;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getAccessibleRole() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_role(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public boolean scrollTo(int n) {
        if (this.ia2 != null) {
            this.ia2.scrollTo(n);
        }
        return false;
    }

    public boolean scrollToPoint(int n, int n2, int n3) {
        if (this.ia2 != null) {
            this.ia2.scrollToPoint(n, n2, n3);
        }
        return false;
    }

    public int[] getGroupPosition() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(3);
            try {
                if (this.ia2.get_groupPosition(nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(2)) == 0) {
                    int[] nArray = new int[]{nativeIntAccess.getInt(0), nativeIntAccess.getInt(1), nativeIntAccess.getInt(2)};
                    return nArray;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getStates() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_states(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public String getExtendedRole() {
        if (this.ia2 != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.ia2.get_extendedRole(nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public String getLocalizedExtendedRole() {
        if (this.ia2 != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.ia2.get_localizedExtendedRole(nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public int getExtendedStateCount() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_nExtendedStates(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public String[] getExtendedStates(int n) {
        if (this.ia2 != null && n > 0) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            try {
                if (this.ia2.get_extendedStates(n, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    String[] stringArray = InternalAccessible2.getStringArray(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1), true);
                    return stringArray;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public String[] getLocalizedExtendedStates(int n) {
        if (this.ia2 != null && n > 0) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            try {
                if (this.ia2.get_localizedExtendedStates(n, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    String[] stringArray = InternalAccessible2.getStringArray(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1), true);
                    return stringArray;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getUniqueID() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_uniqueID(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int getWindowHandle() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_windowHandle(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int getAccessibleIndexInParent() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.ia2.get_indexInParent(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public Locale getLocale() {
        if (this.ia2 != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(3);
            try {
                if (this.ia2.get_locale(nativeIntAccess.getAddress()) == 0) {
                    String[] stringArray = InternalAccessible2.getStringArray(nativeIntAccess.getAddress(), 3, false);
                    Locale locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
                    return locale;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public String getAttributes() {
        if (this.ia2 != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.ia2.get_attributes(nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public static String[] getStringArray(int n, int n2, boolean bl) {
        String[] stringArray = new String[n2];
        if (n2 > 0) {
            int[] nArray = new int[n2];
            MemoryUtil.MoveMemory((int[])nArray, (int)n, (int)(4 * n2));
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = "";
                if (nArray[n3] != 0) {
                    int n4 = COM.SysStringByteLen((int)nArray[n3]);
                    if (n4 > 0) {
                        char[] cArray = new char[(n4 + 1) / 2];
                        MemoryUtil.MoveMemory((char[])cArray, (int)nArray[n3], (int)n4);
                        stringArray[n3] = new String(cArray);
                    }
                    COM.SysFreeString((int)nArray[n3]);
                }
                ++n3;
            }
        }
        if (bl) {
            COM.CoTaskMemFree((int)n);
        }
        return stringArray;
    }
}

