/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYIQ;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;

public class ColorSRGB {
    private ICC_ColorSpace cs;
    private float[] rgb = new float[3];

    public ColorSRGB(float f, float f2, float f3) throws ColorException {
        this.cs = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        this.setR(f);
        this.setG(f2);
        this.setB(f3);
    }

    public ColorSRGB(float f, float f2, float f3, boolean bl) throws ColorException {
        this.cs = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        this.setR(f, bl);
        this.setG(f2, bl);
        this.setB(f3, bl);
    }

    public float getR() {
        return this.rgb[0];
    }

    public float getG() {
        return this.rgb[1];
    }

    public float getB() {
        return this.rgb[2];
    }

    public void setR(float f) throws ColorException {
        this.setR(f, false);
    }

    public void setR(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.rgb[0] = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.rgb[0] = 1.0f;
        } else {
            this.rgb[0] = f;
        }
    }

    public void setG(float f) throws ColorException {
        this.setG(f, false);
    }

    public void setG(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.rgb[1] = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.rgb[1] = 1.0f;
        } else {
            this.rgb[1] = f;
        }
    }

    public void setB(float f) throws ColorException {
        this.setB(f, false);
    }

    public void setB(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.rgb[2] = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.rgb[2] = 1.0f;
        } else {
            this.rgb[2] = f;
        }
    }

    public ColorIRGB toIRGB() throws ColorException {
        return this.toIRGB(false);
    }

    public ColorIRGB toIRGB(boolean bl) throws ColorException {
        int n = Math.round(this.rgb[0] * 255.0f);
        int n2 = Math.round(this.rgb[1] * 255.0f);
        int n3 = Math.round(this.rgb[2] * 255.0f);
        ColorIRGB colorIRGB = new ColorIRGB();
        colorIRGB.setR(n, bl);
        colorIRGB.setG(n2, bl);
        colorIRGB.setB(n3, bl);
        return colorIRGB;
    }

    public ColorXYZ toXYZ() throws ColorException {
        return this.toXYZ(false);
    }

    public ColorXYZ toXYZ(boolean bl) throws ColorException {
        float[] fArray = null;
        boolean bl2 = false;
        while (!bl2) {
            try {
                fArray = this.cs.toCIEXYZ(this.rgb);
                bl2 = true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ColorXYZ colorXYZ = new ColorXYZ();
        colorXYZ.setX(fArray[0], bl);
        colorXYZ.setY(fArray[1], bl);
        colorXYZ.setZ(fArray[2], bl);
        return colorXYZ;
    }

    public ColorYXY toYXY() throws ColorException {
        return this.toYXY(false);
    }

    public ColorYXY toYXY(boolean bl) throws ColorException {
        return this.toXYZ(bl).toYXY(bl);
    }

    public ColorYIQ toYIQ() throws ColorException {
        return new ColorYIQ(this);
    }

    public ColorYIQ toYIQ(boolean bl) throws ColorException {
        return new ColorYIQ(this, bl);
    }
}

