/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.actf.mediator.IACTFReport;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.dom.DomPrintUtil;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.engines.blind.html.util.VisualizeReportUtil;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SaveReportBlind {
    private static final String NULL_STRING = "";
    private static final String TH = "th";
    private static final String TR = "tr";
    private static final String TD = "td";
    private static final String DIV = "div";
    private static final String HR = "hr";
    private static final String STYLE = "style";
    private static final String ALT = "alt";
    private static final String IMG = "img";
    private static final String SRC = "src";
    private static final String[] ICON_NAMES = new String[]{"Err.png", "Warn.png", "Conf.png", "Info.png"};

    public static void saveReport(Document result, IACTFReport checkResult, String sFileName, String imageBriefDir, String maxTime, PageEvaluation pageEval, boolean bAccessory) {
        if (checkResult != null && checkResult instanceof IEvaluationResult) {
            Element el;
            IEvaluationResult evalResult = (IEvaluationResult)checkResult;
            String saveDir = sFileName.substring(0, sFileName.lastIndexOf(File.separator) + 1);
            String imageDir = String.valueOf(saveDir) + imageBriefDir;
            File fDir = new File(imageDir);
            if (!(fDir.isDirectory() && fDir.canWrite() || fDir.mkdirs())) {
                System.err.println("can't create image dir:" + imageDir);
            }
            String preName = sFileName.substring(sFileName.lastIndexOf(File.separator) + 1, sFileName.lastIndexOf("."));
            String scriptVariantName = String.valueOf(preName) + "_variant.js";
            String reportImgSaveName = String.valueOf(preName) + ".png";
            String variantFileS = "variant.js";
            if (bAccessory) {
                File[] assFiles;
                BlindVizResourceUtil.saveImages((String)imageDir);
                BlindVizResourceUtil.saveScripts((String)imageDir);
                File[] fileArray = assFiles = evalResult.getAssociateFiles();
                int n = assFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File target = fileArray[n2];
                    if (target.getName().startsWith("variant") && target.getName().endsWith(".js")) {
                        FileUtils.copyFile((File)target, (String)(String.valueOf(imageDir) + scriptVariantName), (boolean)true);
                        variantFileS = target.getName();
                    } else {
                        FileUtils.copyFile((File)target, (String)(String.valueOf(imageDir) + target.getName()), (boolean)true);
                    }
                    ++n2;
                }
                try {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(imageDir) + scriptVariantName, true), "UTF-8"));
                    pw.write("var acc_imageDir = '" + imageBriefDir + "'; ");
                    pw.flush();
                    pw.close();
                }
                catch (IOException iOException) {}
                FileUtils.copyFile((File)new File(BlindVizResourceUtil.getTempDirectory(), "pagerating.png"), (String)(String.valueOf(imageDir) + reportImgSaveName), (boolean)true);
            }
            IProblemItem[] problemTableBlindDisplayItemArray = new IProblemItem[]{};
            List tmpList = evalResult.getProblemList();
            problemTableBlindDisplayItemArray = new IProblemItem[tmpList.size()];
            try {
                tmpList.toArray(problemTableBlindDisplayItemArray);
            }
            catch (Exception exception) {}
            NodeList nl = result.getElementsByTagName("script");
            int i = 0;
            while (i < nl.getLength()) {
                el = (Element)nl.item(i);
                String strAtt = el.getAttribute(SRC);
                if (strAtt.indexOf("img/") == 0) {
                    el.setAttribute(SRC, String.valueOf(imageBriefDir) + strAtt.substring(4));
                    el.getParentNode().removeChild(el);
                } else if (strAtt.indexOf(variantFileS) >= 0) {
                    el.setAttribute(SRC, String.valueOf(imageBriefDir) + scriptVariantName);
                }
                ++i;
            }
            nl = result.getElementsByTagName("head");
            if (nl.getLength() > 0) {
                Element el2 = (Element)nl.item(0);
                Element newEle = result.createElement("script");
                StringBuffer buffer = new StringBuffer();
                buffer.append(String.valueOf(FileUtils.LINE_SEP) + "if(navigator.appName.toLowerCase().indexOf(\"microsoft\")>=0){" + FileUtils.LINE_SEP);
                buffer.append("jsFile=\"highlight.js\";" + FileUtils.LINE_SEP);
                buffer.append("}else{" + FileUtils.LINE_SEP);
                buffer.append("jsFile=\"highlight_moz.js\";" + FileUtils.LINE_SEP);
                buffer.append("}" + FileUtils.LINE_SEP);
                buffer.append("document.write(\"<script src=\"+acc_imageDir+jsFile+\"></script>\");" + FileUtils.LINE_SEP);
                newEle.appendChild(result.createComment(buffer.toString()));
                el2.appendChild(newEle);
            }
            nl = result.getElementsByTagName(IMG);
            i = 0;
            while (i < nl.getLength()) {
                Element img = (Element)nl.item(i);
                String strAtt = img.getAttribute(SRC);
                if (strAtt.indexOf("img/") == 0) {
                    img.setAttribute(SRC, String.valueOf(imageBriefDir) + strAtt.substring(4));
                }
                ++i;
            }
            nl = result.getElementsByTagName("input");
            i = 0;
            while (i < nl.getLength()) {
                el = (Element)nl.item(i);
                String strAtt = el.getAttribute(SRC);
                if (strAtt.indexOf("img/") == 0) {
                    el.setAttribute(SRC, String.valueOf(imageBriefDir) + strAtt.substring(4));
                }
                ++i;
            }
            NodeList body = result.getElementsByTagName("body");
            if (body.getLength() > 0) {
                Element lastBody = (Element)body.item(0);
                Element tmpElement = result.createElement(HR);
                lastBody.insertBefore(tmpElement, lastBody.getFirstChild());
                Element tmpDiv = result.createElement(DIV);
                tmpDiv.setAttribute(STYLE, "width: 100%; background-color:white;");
                tmpElement = result.createElement(DIV);
                int count = 0;
                boolean[] enabledMetrics = GuidelineHolder.getInstance().getMatchedMetrics();
                int i2 = 0;
                while (i2 < enabledMetrics.length) {
                    if (enabledMetrics[i2]) {
                        ++count;
                    }
                    ++i2;
                }
                if (count > 2) {
                    Element tmpImg = result.createElement(IMG);
                    tmpImg.setAttribute(SRC, String.valueOf(imageBriefDir) + reportImgSaveName);
                    tmpImg.setAttribute(ALT, NULL_STRING);
                    tmpElement.appendChild(tmpImg);
                }
                tmpDiv.appendChild(tmpElement);
                tmpElement = result.createElement(DIV);
                VisualizeReportUtil.appendRatingTableAndTitle((PageEvaluation)pageEval, (String)imageBriefDir, (Document)result, (Node)tmpElement);
                tmpDiv.appendChild(tmpElement);
                lastBody.insertBefore(tmpDiv, lastBody.getFirstChild());
                tmpElement = result.createElement(HR);
                lastBody.insertBefore(tmpElement, lastBody.getFirstChild());
                tmpElement = result.createElement(DIV);
                tmpElement.setAttribute(STYLE, "background-color:white;");
                tmpElement.setAttribute("align", "right");
                Element tmpImg = result.createElement(IMG);
                tmpImg.setAttribute(SRC, String.valueOf(imageBriefDir) + "logo.gif");
                tmpImg.setAttribute(ALT, NULL_STRING);
                tmpElement.appendChild(tmpImg);
                lastBody.insertBefore(tmpElement, lastBody.getFirstChild());
                Element pElement = result.createElement("p");
                lastBody.appendChild(pElement);
                Element tableElement = result.createElement("table");
                tableElement.setAttribute("border", "1");
                tableElement.setAttribute(STYLE, "background-color:white;");
                lastBody.appendChild(tableElement);
                Element trElement = result.createElement(TR);
                tableElement.appendChild(trElement);
                Element tdElement = result.createElement(TH);
                tdElement.appendChild(result.createTextNode(IProblemConst.TITLE_ICON));
                trElement.appendChild(tdElement);
                if (EvaluationUtil.isOriginalDOM()) {
                    tdElement = result.createElement(TH);
                    tdElement.appendChild(result.createTextNode(IProblemConst.TITLE_LINE));
                    trElement.appendChild(tdElement);
                }
                IGuidelineData[] guidelineDataArray = GuidelineHolder.getInstance().getGuidelineData();
                int i3 = 0;
                while (i3 < guidelineDataArray.length) {
                    IGuidelineData data = guidelineDataArray[i3];
                    if (data.isMatched()) {
                        tdElement = result.createElement(TH);
                        tdElement.appendChild(result.createTextNode(data.getGuidelineName()));
                        trElement.appendChild(tdElement);
                    }
                    ++i3;
                }
                tdElement = result.createElement(TH);
                tdElement.appendChild(result.createTextNode(IProblemConst.TITLE_DESCRIPTION));
                trElement.appendChild(tdElement);
                int i4 = 0;
                while (i4 < problemTableBlindDisplayItemArray.length) {
                    IProblemItem current = problemTableBlindDisplayItemArray[i4];
                    trElement = result.createElement(TR);
                    trElement.setAttribute("onClick", "clearTrHighlight();clearHighlight()");
                    if (current.isCanHighlight()) {
                        HighlightTargetId[] targets = current.getHighlightTargetIds();
                        int length = targets.length;
                        String strSet = NULL_STRING;
                        if (length == 1) {
                            strSet = "setHighlight(" + targets[0].getStartId() + "," + targets[0].getEndId() + ");";
                        } else if (length > 1) {
                            StringBuffer strStart = new StringBuffer(2048);
                            StringBuffer strEnd = new StringBuffer(2048);
                            strStart.append(targets[0].getStartId());
                            strEnd.append(targets[0].getEndId());
                            int j = 1;
                            while (j < length) {
                                strStart.append("," + targets[j].getStartId());
                                strEnd.append("," + targets[j].getEndId());
                                ++j;
                            }
                            strSet = "setHighlight2(new Array(" + strStart.toString() + "), new Array(" + strEnd.toString() + "));";
                        }
                        trElement.setAttribute("onclick", "highlightTr(this);clearHighlight();" + strSet);
                        trElement.setAttribute("STYLE", "COLOR:blue;TEXT-DECORATION:underline");
                    }
                    tableElement.appendChild(trElement);
                    tdElement = result.createElement(TD);
                    trElement.appendChild(tdElement);
                    if (current.isCanHighlight()) {
                        Element imgElement = result.createElement(IMG);
                        String imgName = "star.gif";
                        imgElement.setAttribute(SRC, String.valueOf(imageBriefDir) + imgName);
                        imgElement.setAttribute(ALT, NULL_STRING);
                        tdElement.appendChild(imgElement);
                    }
                    String altS = current.getSeverityStr();
                    String imgName = SaveReportBlind.getIconName(current.getSeverity());
                    if (imgName.length() > 0) {
                        Element imgElement = result.createElement(IMG);
                        imgElement.setAttribute(SRC, String.valueOf(imageBriefDir) + imgName);
                        imgElement.setAttribute(ALT, altS);
                        tdElement.appendChild(imgElement);
                    }
                    if (EvaluationUtil.isOriginalDOM()) {
                        tdElement = result.createElement(TD);
                        String sTmp = current.getLineStrMulti();
                        if (sTmp != null && !sTmp.equals(NULL_STRING)) {
                            tdElement.appendChild(result.createTextNode(sTmp));
                        } else {
                            tdElement.appendChild(result.createTextNode("-"));
                        }
                        trElement.appendChild(tdElement);
                    }
                    String[] guidelines = current.getTableDataGuideline();
                    int j = 0;
                    while (j < guidelines.length) {
                        if (guidelineDataArray[j].isMatched()) {
                            tdElement = result.createElement(TD);
                            String sTmp = guidelines[j];
                            if (sTmp != null && !sTmp.equals(NULL_STRING)) {
                                tdElement.appendChild(result.createTextNode(sTmp));
                            } else {
                                tdElement.appendChild(result.createTextNode("-"));
                            }
                            trElement.appendChild(tdElement);
                        }
                        ++j;
                    }
                    tdElement = result.createElement(TD);
                    String desc = current.getDescription();
                    desc = desc.replaceAll("<", "&lt;");
                    desc = desc.replaceAll(">", "&gt;");
                    tdElement.appendChild(result.createTextNode(desc));
                    trElement.appendChild(tdElement);
                    ++i4;
                }
                trElement = result.createElement(TR);
                body.item(body.getLength() - 1).appendChild(trElement);
                tdElement = result.createElement(TD);
                tdElement.appendChild(result.createTextNode(maxTime));
                trElement.appendChild(tdElement);
            }
            DomPrintUtil dpu = new DomPrintUtil(result);
            try {
                dpu.writeToFile(sFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getIconName(int id) {
        switch (id) {
            case 1: {
                return ICON_NAMES[0];
            }
            case 2: {
                return ICON_NAMES[1];
            }
            case 4: {
                return ICON_NAMES[2];
            }
            case 8: {
                return ICON_NAMES[3];
            }
        }
        return NULL_STRING;
    }
}

