/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.adapt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.core.adapt.IAdaptor;
import org.eclipse.actf.core.adapt.IAdaptorFactory;
import org.eclipse.actf.util.resources.ClassLoaderCache;

public class DefaultAdaptorFactory
implements IAdaptorFactory {
    protected static final ClassLoaderCache _clCache = ClassLoaderCache.getDefault();
    private static DefaultAdaptorFactory factoryInstance;
    private Map _adaptorMap = new HashMap();

    protected DefaultAdaptorFactory() {
    }

    public static DefaultAdaptorFactory getInstance() {
        if (factoryInstance == null) {
            factoryInstance = new DefaultAdaptorFactory();
        }
        return factoryInstance;
    }

    public void registerAdaptor(Class type, IAdaptor adaptor) {
        String typeName = type.getName();
        LinkedList<IAdaptor> adaptors = (LinkedList<IAdaptor>)this._adaptorMap.get(typeName);
        if (adaptors == null) {
            adaptors = new LinkedList<IAdaptor>();
            this._adaptorMap.put(typeName, adaptors);
        }
        adaptors.add(adaptor);
    }

    public IAdaptor[] getAdaptors(Class type) {
        return this.getAdaptors(type.getName());
    }

    public IAdaptor[] getAdaptors(String className) {
        List l = (List)this._adaptorMap.get(className);
        return l == null ? new IAdaptor[]{} : l.toArray(new IAdaptor[l.size()]);
    }

    public IAdaptor[] getAllAdaptors(Class targetType) {
        Class<?>[] ints = targetType.getInterfaces();
        ArrayList<IAdaptor> adaptorList = new ArrayList<IAdaptor>();
        do {
            List adaptors;
            if ((adaptors = (List)this._adaptorMap.get(targetType.getName())) == null || adaptors.isEmpty()) continue;
            adaptorList.addAll(adaptors);
        } while ((targetType = targetType.getSuperclass()) != null);
        int i = 0;
        while (i < ints.length) {
            List<IAdaptor> adaptors2;
            List adaptors = (List)this._adaptorMap.get(ints[i].getName());
            if (adaptors != null && !adaptors.isEmpty()) {
                adaptorList.addAll(adaptors);
            }
            if ((adaptors2 = Arrays.asList(this.getAllAdaptors(ints[i]))) != null && !adaptors2.isEmpty()) {
                adaptorList.addAll(adaptors2);
            }
            ++i;
        }
        return adaptorList.isEmpty() ? new IAdaptor[]{} : adaptorList.toArray(new IAdaptor[adaptorList.size()]);
    }
}

