/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.ui.report.table.ResultTableSorterBase;
import org.eclipse.jface.viewers.Viewer;

public class ResultTableSorter
extends ResultTableSorterBase {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean inverse = false;
    private int curColumn = -1;
    private int metricsFinPos = this.guidelineHolder.getMetricsNames().length + 1;
    private int guidelineFinPos = this.metricsFinPos + this.guidelineHolder.getGuidelineData().length;

    protected int compareTotalScore(IProblemItem item1, IProblemItem item2) {
        int[] score1 = item1.getMetricsScores();
        int[] score2 = item2.getMetricsScores();
        int result = 0;
        boolean[] isEnabled = this.guidelineHolder.getMatchedMetrics();
        int i = 0;
        while (i < score1.length) {
            if (isEnabled[i]) {
                result += score2[i] - score1[i];
            }
            ++i;
        }
        return result;
    }

    protected int compareHighlight(IProblemItem tmp1, IProblemItem tmp2) {
        boolean b2;
        boolean b1 = tmp1.isCanHighlight();
        if (b1 == (b2 = tmp2.isCanHighlight())) {
            return this.compareTotalScore(tmp1, tmp2);
        }
        if (b1) {
            return -1;
        }
        return 1;
    }

    public int compare(Viewer arg0, Object arg1, Object arg2) {
        int result = 0;
        if (arg1 != null && arg2 != null) {
            try {
                IProblemItem tmp1 = (IProblemItem)arg1;
                IProblemItem tmp2 = (IProblemItem)arg2;
                result = this.curColumn == -1 ? this.compareTotalScore(tmp1, tmp2) : (this.curColumn == 0 ? this.compareHighlight(tmp1, tmp2) : (this.curColumn < this.metricsFinPos ? this.compareScore(tmp1, tmp2, this.curColumn - 1) : (this.curColumn < this.guidelineFinPos ? this.compareGuideline(tmp1, tmp2, this.curColumn - this.metricsFinPos) : (this.curColumn == this.guidelineFinPos ? this.compareEvalItem(tmp1.getEvaluationItem(), tmp2.getEvaluationItem()) : (this.curColumn == this.guidelineFinPos + 1 ? this.compareLine(tmp1, tmp2) : this.compareString(tmp1.getDescription(), tmp2.getDescription()))))));
                if (result == 0 && (result = this.compareSeverity(tmp1, tmp2)) == 0) {
                    result = tmp1.getSerialNumber() - tmp2.getSerialNumber();
                }
                if (this.inverse) {
                    return -result;
                }
                return result;
            }
            catch (Exception exception) {}
        }
        return super.compare(arg0, arg1, arg2);
    }

    public void setCurColumn(int curColumn) {
        if (this.curColumn == curColumn) {
            this.inverse = !this.inverse;
        } else {
            this.inverse = false;
            this.curColumn = curColumn;
        }
    }

    public void reset() {
        this.curColumn = -1;
        this.inverse = false;
    }
}

