/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.action;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.action.ShowTechniquesAction;
import org.eclipse.actf.visualization.internal.ui.report.table.ResultTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechniquesSubMenu
extends MenuManager {
    private TableViewer _tableViewer;
    private Action _dummy;

    public TechniquesSubMenu(ResultTableViewer resultTableViewer) {
        super(Messages.ViewTechniques);
        this._tableViewer = resultTableViewer.getTableViewer();
        this._tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                List tmpList = ((IStructuredSelection)arg0.getSelection()).toList();
                TechniquesSubMenu.this.setTechniques(tmpList);
            }
        });
        this._dummy = new Action(Messages.NoTechniques){};
        this._dummy.setEnabled(false);
        this.add((IAction)this._dummy);
    }

    public void setTechniques(List<IProblemItem> target) {
        this.removeAll();
        TreeSet<IEvaluationItem> tmpSet = new TreeSet<IEvaluationItem>(new Comparator<IEvaluationItem>(){

            @Override
            public int compare(IEvaluationItem o1, IEvaluationItem o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        for (IProblemItem tmpItem : target) {
            tmpSet.add(tmpItem.getEvaluationItem());
        }
        TreeSet<ITechniquesItem> techSet = new TreeSet<ITechniquesItem>(new Comparator<ITechniquesItem>(){

            @Override
            public int compare(ITechniquesItem o1, ITechniquesItem o2) {
                int flag = o1.getGuidelineName().compareTo(o2.getGuidelineName());
                if (flag == 0) {
                    flag = o1.getId().compareTo(o2.getId());
                }
                return flag;
            }
        });
        for (IEvaluationItem eval : tmpSet) {
            IGuidelineItem[] guidelines = eval.getGuidelines();
            ITechniquesItem[][] techs = eval.getTechniques();
            int j = 0;
            while (j < guidelines.length) {
                if (guidelines[j].isEnabled()) {
                    techSet.addAll(Arrays.asList(techs[j]));
                }
                ++j;
            }
        }
        Iterator<IEvaluationItem> i = techSet.iterator();
        while (i.hasNext()) {
            this.add((IAction)new ShowTechniquesAction((ITechniquesItem)i.next()));
        }
        if (this.getItems().length == 0) {
            this.add((IAction)this._dummy);
        }
    }
}

