/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report;

import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ReportMessageDialog {
    public static void openReportMEssageDialog(Shell shell, IProblemItem curItem) {
        if (shell == null || curItem == null) {
            return;
        }
        StringBuffer tmpSB = new StringBuffer();
        if (Platform.inDevelopmentMode()) {
            tmpSB.append(String.valueOf(curItem.getId()) + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        }
        IGuidelineData[] dataArray = GuidelineHolder.getInstance().getGuidelineData();
        int i = 0;
        while (i < dataArray.length) {
            if (dataArray[i].isMatched()) {
                tmpSB.append(String.valueOf(dataArray[i].getGuidelineName()) + ": " + curItem.getTableDataGuideline()[i] + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
            }
            ++i;
        }
        tmpSB.append(String.valueOf(IProblemConst.TITLE_TECHNIQUS) + ": " + curItem.getEvaluationItem().getTableDataTechniques() + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        String lineS = curItem.getLineStrMulti();
        if (lineS != null && lineS.length() > 0) {
            tmpSB.append(String.valueOf(IProblemConst.TITLE_LINE) + ": " + lineS + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        }
        tmpSB.append(String.valueOf(IProblemConst.TITLE_DESCRIPTION) + ": " + FileUtils.LINE_SEP + curItem.getDescription());
        switch (curItem.getSeverity()) {
            case 1: {
                MessageDialog.openError((Shell)shell, (String)IProblemConst.ESSENTIAL, (String)tmpSB.toString());
                break;
            }
            case 2: {
                MessageDialog.openWarning((Shell)shell, (String)IProblemConst.WARNING, (String)tmpSB.toString());
                break;
            }
            case 4: {
                MessageDialog.openInformation((Shell)shell, (String)IProblemConst.USER_CHECK, (String)tmpSB.toString());
                break;
            }
            case 8: {
                MessageDialog.openInformation((Shell)shell, (String)IProblemConst.INFO, (String)tmpSB.toString());
            }
        }
    }
}

