/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report;

import java.io.File;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ReportDisplay {
    private static final String WEBBROWSER_CONTROL_NAME = "Shell.Explorer";
    private static final String NAVIGATE_METHOD_NAME = "Navigate";
    private static final String URL_PARAM_NAME = "URL";
    private OleFrame webFrame;
    private OleControlSite webControlSite;
    private OleAutomation oleAutomation;
    private int dispIdMember;
    int[] rgdispidNamedArgs = new int[1];

    public void disposeOleBrowser() {
        if (this.oleAutomation != null) {
            this.oleAutomation.dispose();
            this.oleAutomation = null;
        }
    }

    public ReportDisplay(Composite _compositeParent) {
        Composite compositeRecommendationHalf = new Composite(_compositeParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        compositeRecommendationHalf.setLayout((Layout)gridLayout);
        this.webFrame = new OleFrame(compositeRecommendationHalf, 0);
        this.webControlSite = new OleControlSite((Composite)this.webFrame, 0, WEBBROWSER_CONTROL_NAME);
        this.oleAutomation = new OleAutomation((OleClientSite)this.webControlSite);
        if (this.webControlSite.doVerb(-5) != 0) {
            DebugPrintUtil.devOrDebugPrintln((Object)"ole init failure");
        }
        if (this.oleAutomation != null) {
            int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{NAVIGATE_METHOD_NAME, URL_PARAM_NAME});
            this.dispIdMember = rgdispid[0];
            int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.webFrame.setLayoutData((Object)gridData);
        this.displayReportFile("");
    }

    public void displayReportFile(String url) {
        File targetFile = new File(url);
        if (!targetFile.exists()) {
            url = "about:blank";
        }
        if (this.oleAutomation != null) {
            Variant[] rgvarg = new Variant[]{new Variant(url)};
            this.oleAutomation.invoke(this.dispIdMember, rgvarg, this.rgdispidNamedArgs);
        }
    }

    public OleControlSite getOleControleSite() {
        return this.webControlSite;
    }
}

