/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.Stack;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.util.win32.OverlayLabel;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.AccessiblePropertyUtil;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.preferences.GuiPreferenceManager;
import org.eclipse.actf.visualization.gui.ui.actions.HideHtmlAction;
import org.eclipse.actf.visualization.gui.ui.actions.RefreshRootAction;
import org.eclipse.actf.visualization.gui.ui.actions.ShowOffscreenAction;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAProblemsView;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class MSAAOutlineView
extends ViewPart
implements IMSAAOutlineView {
    public static Color FLASH_COLOR = Display.getCurrent().getSystemColor(13);
    public static Color INVISIBLE_FLASH_COLOR = Display.getCurrent().getSystemColor(3);
    private TreeViewer viewer;
    private Action expandAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private RefreshRootAction refreshAction;
    private HideHtmlAction hideHtmlAction;
    private ShowOffscreenAction showOffscreenAction;
    private Action runCheckerAction;
    private Action showLabelsAction;
    private boolean suppressLabelAdjust = false;
    private boolean ignoreSelection = false;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)MSAATreeContentProvider.getDefault());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MSAATreeLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
                    if (selectedObject != null) {
                        if (!MSAAOutlineView.this.ignoreSelection) {
                            MSAAViewRegistory.outlineSelected(selectedObject);
                        }
                        if (!MSAAOutlineView.this.suppressLabelAdjust && MSAAOutlineView.this.showLabelsAction.isChecked()) {
                            MSAAOutlineView.this.showOverlayLabels();
                        }
                    } else {
                        HighlightComposite.show((boolean)false);
                    }
                }
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                MSAAOutlineView.this.refreshLabels();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                MSAAOutlineView.this.refreshLabels();
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        MSAAViewRegistory.refreshRootObject();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MSAAViewRegistory.showView(IGuiViewIDs.ID_EVENTVIEW, false);
            }
        });
        HighlightComposite.initOverlayWindow();
    }

    private void refreshLabels() {
        if (this.showLabelsAction.isChecked()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MSAAOutlineView.this.showOverlayLabels();
                }
            });
        }
    }

    public void refresh() {
        OverlayLabel.removeAll();
        AccessibleObject rootObject = MSAAViewRegistory.getRootObject();
        if (rootObject != null) {
            this.ignoreSelection = true;
            try {
                try {
                    this.viewer.setInput((Object)rootObject);
                    AccessibleObject selection = MSAAViewRegistory.adjustSelection(rootObject);
                    if (selection != null) {
                        this.viewer.setSelection((ISelection)new StructuredSelection((Object)selection));
                        if (selection.getChildCount() < 100) {
                            this.viewer.setExpandedState((Object)selection, true);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.ignoreSelection = false;
                }
            }
            finally {
                this.ignoreSelection = false;
            }
        }
    }

    public void setSelection(Object element) {
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (element instanceof AccessibleObject) {
            Stack<AccessibleObject> stack = new Stack<AccessibleObject>();
            AccessibleObject accParent = (AccessibleObject)element;
            while ((accParent = accParent.getCachedParent()) != null && !this.viewer.getExpandedState((Object)accParent)) {
                stack.push(accParent);
            }
            while (!stack.isEmpty()) {
                this.viewer.setExpandedState(stack.pop(), true);
            }
            selection = new StructuredSelection(element);
        }
        this.viewer.setSelection((ISelection)selection, true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MSAAOutlineView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showOffscreenAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.hideHtmlAction);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MSAAOutlineView.this.showOffscreenAction.adjust();
                MSAAOutlineView.this.hideHtmlAction.adjust();
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showLabelsAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        Object selected = this.getSelectedItem();
        if (selected != null) {
            manager.add((IAction)this.expandAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runCheckerAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.runCheckerAction);
        manager.add((IAction)this.showLabelsAction);
    }

    private void makeActions() {
        Shell shell = this.getViewSite().getShell();
        this.expandAction = new Action(Messages.msaa_expand){

            public void run() {
                try {
                    Object selected = MSAAOutlineView.this.getSelectedItem();
                    if (selected != null) {
                        MSAAOutlineView.this.viewer.expandToLevel(selected, -1);
                    }
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        };
        this.expandAllAction = new Action(Messages.msaa_expand_all){

            public void run() {
                try {
                    MSAAOutlineView.this.viewer.expandAll();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        };
        this.expandAllAction.setToolTipText(Messages.msaa_expand_all);
        this.expandAllAction.setImageDescriptor(GuiImages.IMAGE_EXPAND_ALL);
        this.collapseAllAction = new Action(Messages.msaa_collapse_all){

            public void run() {
                try {
                    MSAAOutlineView.this.viewer.collapseAll();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        };
        this.collapseAllAction.setToolTipText(Messages.msaa_collapse_all);
        this.collapseAllAction.setImageDescriptor(GuiImages.IMAGE_COLLAPSE_ALL);
        this.refreshAction = new RefreshRootAction();
        this.hideHtmlAction = new HideHtmlAction();
        this.showOffscreenAction = new ShowOffscreenAction();
        this.runCheckerAction = new Action(Messages.msaa_checker){

            public void run() {
                IMSAAProblemsView problemsView = (IMSAAProblemsView)MSAAViewRegistory.showView(IGuiViewIDs.ID_REPORTVIEW, true);
                if (problemsView != null) {
                    problemsView.refresh();
                }
            }
        };
        this.runCheckerAction.setToolTipText(Messages.msaa_checker_tip);
        this.runCheckerAction.setImageDescriptor(GuiImages.IMAGE_CHECKER);
        this.showLabelsAction = new Action(Messages.msaa_show_tree, 2){

            public void run() {
                MSAAOutlineView.this.showOverlayLabels();
            }
        };
        this.showLabelsAction.setToolTipText(Messages.msaa_show_tree);
        this.showLabelsAction.setImageDescriptor(GuiImages.IMAGE_OVERLAY);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (IGuiViewIDs.ID_OUTLINEVIEW.equals(OverlayLabel.getOwnerId())) {
                    MSAAOutlineView.this.showOverlayLabels();
                }
            }

            public void shellDeactivated(ShellEvent e) {
                if (IGuiViewIDs.ID_OUTLINEVIEW.equals(OverlayLabel.getOwnerId())) {
                    OverlayLabel.removeAll((boolean)false);
                }
            }
        });
        this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
        IPreferenceStore store = GuiPreferenceManager.getPreferenceStore();
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("UseOverlayWindow".equals(event.getProperty())) {
                    MSAAOutlineView.this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
                }
            }
        });
    }

    private void showOverlayLabels() {
        OverlayLabel.removeAll();
        if (this.showLabelsAction.isChecked()) {
            new LabelOverlay().showLabels(this.viewer.getTree().getSelection());
            OverlayLabel.setOwnerId((String)IGuiViewIDs.ID_OUTLINEVIEW);
        }
    }

    private void showSelectionMenu(OverlayLabel[] labels, OverlayLabel parent) {
        Menu popupMenu = parent.createPopupMenu();
        MenuItem[] menuItems = new MenuItem[labels.length];
        int i = 0;
        while (i < labels.length) {
            menuItems[i] = new MenuItem(popupMenu, 8);
            menuItems[i].setText(labels[i].getMenuText());
            menuItems[i].setImage(labels[i].getImage());
            menuItems[i].setData(labels[i].associatedObject);
            menuItems[i].addArmListener(new ArmListener(){

                public void widgetArmed(ArmEvent e) {
                    Object data = ((MenuItem)e.getSource()).getData();
                    if (data instanceof AccessibleObject) {
                        HighlightComposite.flashRectangle((Rectangle)((AccessibleObject)data).getAccLocation());
                    }
                }
            });
            menuItems[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object data = ((MenuItem)e.getSource()).getData();
                    MSAAOutlineView.this.suppressLabelAdjust = true;
                    MSAAOutlineView.this.viewer.setSelection((ISelection)new StructuredSelection(data));
                    MSAAOutlineView.this.suppressLabelAdjust = false;
                }
            });
            ++i;
        }
        popupMenu.setVisible(true);
    }

    private Object getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            return selection.getFirstElement();
        }
        return null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static String getTreeText(Object element) {
        if (element instanceof AccessibleObject) {
            AccessibleObject accObject = (AccessibleObject)element;
            try {
                String accText = accObject.getAccName();
                if (accText == null || accText.length() == 0) {
                    switch (accObject.getAccRole()) {
                        case 1044: 
                        case 1054: {
                            accText = accObject.getAccValue();
                        }
                    }
                }
                if (accText == null || accText.length() == 0) {
                    accText = Messages.msaa_NAMELESS;
                    String roleText = accObject.getRoleText();
                    if (roleText != null) {
                        accText = String.valueOf(accText) + " (" + roleText + ")";
                    }
                }
                return accText;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return element.toString();
    }

    private Color getFlashBackground(AccessibleObject accObject) {
        switch (accObject.getAccRole()) {
            case 9: {
                if (!FlashMSAAUtil.isFlash((int)accObject.getPtr())) break;
                return FLASH_COLOR;
            }
            case 10: {
                if (!FlashMSAAUtil.isInvisibleFlash((int)accObject.getPtr())) break;
                return INVISIBLE_FLASH_COLOR;
            }
        }
        return null;
    }

    private class LabelOverlay {
        int index = 0;
        TreeItem currentItem = null;

        private LabelOverlay() {
        }

        public void showLabels(TreeItem[] items) {
            if (items.length == 1) {
                this.currentItem = items[0];
                TreeItem parent = this.currentItem.getParentItem();
                if (parent != null) {
                    items = parent.getItems();
                }
            }
            this.renderLabels(items);
        }

        public void renderLabels(TreeItem[] items) {
            int i = 0;
            while (i < items.length) {
                OverlayLabel label;
                Rectangle location;
                Object treeObject = items[i].getData();
                if (treeObject instanceof AccessibleObject && (location = ((AccessibleObject)treeObject).getAccLocation()) != null && (label = OverlayLabel.create((Object)treeObject)) != null) {
                    if (items[i].equals(this.currentItem)) {
                        label.setForeground(label.getDisplay().getSystemColor(27));
                        label.setBackground(label.getDisplay().getSystemColor(26));
                    }
                    MSAATreeLabelProvider labelProvider = (MSAATreeLabelProvider)MSAAOutlineView.this.viewer.getLabelProvider();
                    label.setImage(labelProvider.getImage(treeObject));
                    label.setText("" + this.index);
                    String text = "[" + this.index + "] " + labelProvider.getText(treeObject);
                    String[][] properties = AccessiblePropertyUtil.getPropertyStrings(treeObject);
                    label.setTooltop(text, properties);
                    label.pack();
                    label.setLocation(location.x, location.y);
                    ++this.index;
                    label.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            if (e.widget instanceof OverlayLabel) {
                                OverlayLabel[] labels = OverlayLabel.getLabelsAtPosition((Point)e.display.getCursorLocation());
                                if (labels.length > 0) {
                                    MSAAOutlineView.this.showSelectionMenu(labels, (OverlayLabel)e.widget);
                                } else {
                                    MSAAOutlineView.this.suppressLabelAdjust = true;
                                    MSAAOutlineView.this.viewer.setSelection((ISelection)new StructuredSelection(((OverlayLabel)e.widget).associatedObject));
                                    MSAAOutlineView.this.suppressLabelAdjust = false;
                                }
                            }
                        }
                    });
                    label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                        public void mouseEnter(MouseEvent e) {
                            AccessibleObject object;
                            if (e.widget instanceof OverlayLabel && (object = (AccessibleObject)((OverlayLabel)e.widget).associatedObject) != null) {
                                HighlightComposite.flashRectangle((Rectangle)object.getAccLocation());
                            }
                        }

                        public void mouseExit(MouseEvent e) {
                            HighlightComposite.show((boolean)false);
                        }
                    });
                }
                if (items[i].getExpanded()) {
                    this.renderLabels(items[i].getItems());
                }
                ++i;
            }
        }
    }

    private class MSAATreeLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private Color colorInvisible = Display.getCurrent().getSystemColor(15);

        private MSAATreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Accessible2 ac2;
            String imageKey = null;
            if (element instanceof AccessibleObject && (imageKey = GuiImages.roleIcon(((AccessibleObject)element).getAccRole())) == null && (ac2 = ((AccessibleObject)element).getAccessible2()) != null) {
                imageKey = GuiImages.roleIcon("IA2_ROLE_UNKNOWN");
            }
            if (imageKey == null) {
                imageKey = GuiImages.roleIcon("ROLE_UNKNOWN");
            }
            return GuiImages.getImage(imageKey);
        }

        public String getText(Object element) {
            return MSAAOutlineView.getTreeText(element);
        }

        public Color getBackground(Object element) {
            if (element instanceof AccessibleObject) {
                return MSAAOutlineView.this.getFlashBackground((AccessibleObject)element);
            }
            return null;
        }

        public Color getForeground(Object element) {
            int accState;
            if (element instanceof AccessibleObject && ((accState = ((AccessibleObject)element).getAccState()) & 0x8000) != 0) {
                return this.colorInvisible;
            }
            return null;
        }
    }
}

