/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.preferences;

import org.eclipse.actf.util.win32.OverlayWindow;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.actf.visualization.gui.ui.actions.WindowListAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class GuiPreferenceManager {
    private static IPreferenceStore preferenceStore = GuiPlugin.getDefault().getPreferenceStore();

    public static void init() {
        GuiPreferenceManager.resetOverlayWindow();
        GuiPreferenceManager.resetAlwaysOnTop();
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String name = event.getProperty();
                if ("UseOverlayWindow".equals(name)) {
                    GuiPreferenceManager.resetOverlayWindow();
                } else if ("AlwaysOnTop".equals(name)) {
                    GuiPreferenceManager.resetAlwaysOnTop();
                }
            }
        });
    }

    private static void resetOverlayWindow() {
        OverlayWindow.setVisible((boolean)GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
    }

    private static void resetAlwaysOnTop() {
        WindowListAction.setWindowOrder(GuiPreferenceManager.getPreferenceBoolean("AlwaysOnTop"));
    }

    public static IPreferenceStore getPreferenceStore() {
        return preferenceStore;
    }

    public static String getPreferenceString(String name) {
        return preferenceStore.getString(name);
    }

    public static boolean getPreferenceBoolean(String name) {
        return preferenceStore.getBoolean(name);
    }

    public static void setPreference(String name, String value) {
        preferenceStore.setValue(name, value);
    }

    public static void setPreference(String name, boolean value) {
        preferenceStore.setValue(name, value);
    }
}

