/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.methods;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.actf.accservice.swtbridge.IA2;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.AbstractInputField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IA2CoordTypeField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IA2ScrollTypeField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IA2TextBoundaryTypeField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IntegerField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.MSAASELFLAGField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.TextField;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public abstract class MethodData {
    private String title;
    private boolean supportInvoke;
    private AbstractInputField[] inputFields = new AbstractInputField[0];
    protected Object result = PRESS_ENTER_MSG;
    private static final String PRESS_ENTER_MSG = Messages.props_pressEnter;
    private static final String PRESS_OK_MSG = Messages.props_pressOK;
    private static final String INVALID_FIELD_MSG = Messages.props_invalid;
    private static final String VALID_RANGE_MSG = Messages.props_range;
    private static final String SUCCESS_MSG = Messages.props_success;
    private static final String FAIL_MSG = Messages.props_fail;

    protected String getInvalidArgMessage(AbstractInputField field) {
        int maxValue;
        int minValue;
        String label = field.getLabelText();
        if (field instanceof IntegerField && (minValue = ((IntegerField)field).minValue) <= (maxValue = ((IntegerField)field).maxValue)) {
            return MessageFormat.format((String)VALID_RANGE_MSG, (Object[])new Object[]{label, new Integer(minValue), new Integer(maxValue)});
        }
        return MessageFormat.format((String)INVALID_FIELD_MSG, (Object[])new Object[]{label});
    }

    public MethodData(String title, boolean supportInvoke) {
        this.title = title;
        this.supportInvoke = supportInvoke;
    }

    public void setInputFields(AbstractInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public final String getTitle() {
        return this.title;
    }

    public final boolean canInvole() {
        return this.supportInvoke;
    }

    public boolean invoke() {
        return this.supportInvoke;
    }

    public Object getResult() {
        return this.result;
    }

    protected final void createControl(Composite parent) {
        int i = 0;
        while (i < this.inputFields.length) {
            this.inputFields[i].createLabelAndControl(parent);
            ++i;
        }
    }

    protected final boolean validate() {
        int i = 0;
        while (i < this.inputFields.length) {
            AbstractInputField field = this.inputFields[i];
            if (!field.validate()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected final String getMessage() {
        int i = 0;
        while (i < this.inputFields.length) {
            AbstractInputField field = this.inputFields[i];
            if (!field.validate()) {
                return this.getInvalidArgMessage(field);
            }
            ++i;
        }
        return PRESS_OK_MSG;
    }

    protected final void setModifyListener(ModifyListener listener) {
        int i = 0;
        while (i < this.inputFields.length) {
            AbstractInputField field = this.inputFields[i];
            field.setModifyListener(listener);
            ++i;
        }
    }

    protected final void update() {
        int i = 0;
        while (i < this.inputFields.length) {
            AbstractInputField field = this.inputFields[i];
            field.update();
            ++i;
        }
    }

    protected final String getParameters() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.inputFields.length) {
            if (i > 0) {
                sb.append(", ");
            }
            AbstractInputField field = this.inputFields[i];
            sb.append(field.getLabelText());
            sb.append("=");
            if (field instanceof IA2CoordTypeField) {
                int coordType = ((IA2CoordTypeField)field).getIntValue();
                sb.append(IA2.getCoordTypeText(coordType));
            } else if (field instanceof IA2ScrollTypeField) {
                int scrollType = ((IA2ScrollTypeField)field).getIntValue();
                sb.append(IA2.getScrollTypeText(scrollType));
            } else if (field instanceof IA2TextBoundaryTypeField) {
                int textBoundaryType = ((IA2TextBoundaryTypeField)field).getIntValue();
                sb.append(IA2.getTextBoundaryTypeText(textBoundaryType));
            } else if (field instanceof MSAASELFLAGField) {
                int flag = ((MSAASELFLAGField)field).getIntValue();
                sb.append("0x" + Integer.toHexString(flag));
            } else if (field instanceof IntegerField) {
                int value = ((IntegerField)field).getIntValue();
                sb.append(Integer.toString(value));
            } else if (field instanceof TextField) {
                String value = ((TextField)field).getStringValue();
                sb.append(MethodData.T(value));
            }
            ++i;
        }
        return sb.toString();
    }

    protected final String formatResult(boolean success) {
        return this.formatResult(success ? SUCCESS_MSG : FAIL_MSG);
    }

    protected final String formatResult(String rc) {
        String param = this.getParameters();
        if (param.length() > 0) {
            return String.valueOf(rc) + " [" + param + "]";
        }
        return rc;
    }

    protected static String T(String str) {
        if (str == null) {
            return "(null)";
        }
        return "\"" + str + "\"";
    }
}

