/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.visualization.gui.TargetWindowDataProvider;
import org.eclipse.actf.visualization.gui.internal.GuiTargetWindowData;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindow;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetWindowDataCollector {
    private static final String TARGETDATA_EXTENSION = "org.eclipse.actf.visualization.gui.targetWindowData";
    private static TargetWindowDataProvider[] targetDataProviders = new TargetWindowDataProvider[0];
    private Map<String, List<Object>> categoryMap = new HashMap<String, List<Object>>();

    static {
        ArrayList<TargetWindowDataProvider> dspList = new ArrayList<TargetWindowDataProvider>();
        IConfigurationElement[] targetDataElements = Platform.getExtensionRegistry().getConfigurationElementsFor(TARGETDATA_EXTENSION);
        int i = 0;
        while (i < targetDataElements.length) {
            try {
                TargetWindowDataProvider provider = (TargetWindowDataProvider)targetDataElements[i].createExecutableExtension("class");
                if (provider != null) {
                    dspList.add(provider);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        targetDataProviders = dspList.toArray(new TargetWindowDataProvider[dspList.size()]);
    }

    public static Object[] getElements() {
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = 0;
        while (i < targetDataProviders.length) {
            if (targetDataProviders[i] != null) {
                IModelService[] elements = targetDataProviders[i].getModelService();
                if (elements != null) {
                    resultList.addAll(Arrays.asList(elements));
                } else {
                    resultList.add(targetDataProviders[i]);
                }
            }
            ++i;
        }
        return resultList.toArray();
    }

    public static Object getDefaultElement() {
        Object[] elements = TargetWindowDataCollector.getElements();
        int i = 0;
        while (i < elements.length) {
            if (TargetWindow.isEmbeddedBrowser(elements[i])) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    public TargetWindowDataCollector() {
        Object[] elements = TargetWindowDataCollector.getElements();
        int i = 0;
        while (i < elements.length) {
            List<Object> entry;
            String category = null;
            if (elements[i] instanceof GuiTargetWindowData) {
                category = ((GuiTargetWindowData)elements[i]).getCategory();
            }
            if ((entry = this.categoryMap.get(category)) == null) {
                entry = new ArrayList<Object>();
                this.categoryMap.put(category, entry);
            }
            entry.add(elements[i]);
            ++i;
        }
    }

    public String[] getCategories(Comparator<Object> comparator) {
        ArrayList<String> resultList = new ArrayList<String>(this.categoryMap.keySet());
        if (comparator != null) {
            Collections.sort(resultList, comparator);
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public Object[] getElements(String category) {
        List<Object> resultList = this.categoryMap.get(category);
        if (resultList != null) {
            return resultList.toArray();
        }
        return new Object[0];
    }
}

