/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.ModelServiceSizeInfo;
import org.eclipse.actf.visualization.ui.IPositionSize;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationCanvas
extends Canvas {
    private final Display display;
    private Image image = null;
    private ImageData imageData = null;
    private int curX;
    private int curY;
    private ScrollBar horizontalBar;
    private ScrollBar verticalBar;
    private List<IPositionSize> highlightTargetList = new ArrayList<IPositionSize>();
    private IModelService current = null;
    private IModelService target = null;
    private String targetUrl = null;
    private boolean sync = true;

    public VisualizationCanvas(Composite parent) {
        this(parent, 0);
    }

    public VisualizationCanvas(Composite parent, int style) {
        super(parent, 0x300 | style);
        this.display = parent.getDisplay();
        this.init();
        parent.getShell().addListener(100, new Listener(){

            public void handleEvent(Event e) {
                VisualizationCanvas.this.setVScrollBar(e.detail);
            }
        });
    }

    private void init() {
        this.setBackground(new Color((Device)this.display, 255, 255, 255));
        this.curX = 0;
        this.curY = 0;
        this.horizontalBar = this.getHorizontalBar();
        this.horizontalBar.setVisible(true);
        this.horizontalBar.setMinimum(0);
        this.horizontalBar.setEnabled(false);
        this.horizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                VisualizationCanvas.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        this.verticalBar = this.getVerticalBar();
        this.verticalBar.setVisible(true);
        this.verticalBar.setMinimum(0);
        this.verticalBar.setEnabled(false);
        this.verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                VisualizationCanvas.this.scrollVertically((ScrollBar)event.widget);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (VisualizationCanvas.this.imageData == null) {
                    return;
                }
                if (VisualizationCanvas.this.image != null) {
                    VisualizationCanvas.this.paintImage(event);
                }
                VisualizationCanvas.this.resizeScrollBars();
            }
        });
    }

    private void paintImage(PaintEvent event) {
        if (this.image == null || this.imageData == null) {
            return;
        }
        Image paintImage = this.image;
        int w = Math.round(this.imageData.width);
        int h = Math.round(this.imageData.height);
        event.gc.drawImage(paintImage, 0, 0, this.imageData.width, this.imageData.height, this.curX + this.imageData.x, this.curY + this.imageData.y, w, h);
        List<IPositionSize> tmpV = this.highlightTargetList;
        if (tmpV != null) {
            event.gc.setLineWidth(2);
            for (IPositionSize ips : tmpV) {
                event.gc.setForeground(this.display.getSystemColor(1));
                event.gc.drawRectangle(this.curX + ips.getX(), this.curY + ips.getY(), ips.getWidth(), ips.getHeight());
                event.gc.setForeground(this.display.getSystemColor(2));
                event.gc.drawRectangle(this.curX + ips.getX() - 2, this.curY + ips.getY() - 2, ips.getWidth() + 4, ips.getHeight() + 4);
            }
        }
    }

    protected void resetScrollBars() {
        if (this.image == null) {
            this.horizontalBar.setEnabled(false);
            this.verticalBar.setEnabled(false);
            return;
        }
        this.curX = 0;
        this.curY = 0;
        this.resizeScrollBars();
        this.horizontalBar.setSelection(0);
        this.verticalBar.setSelection(0);
    }

    private void resizeScrollBars() {
        if (this.imageData == null) {
            return;
        }
        Rectangle canvasBounds = this.getClientArea();
        int width = Math.round(this.imageData.width);
        if (width > canvasBounds.width) {
            this.horizontalBar.setEnabled(true);
            this.horizontalBar.setMaximum(width);
            this.horizontalBar.setThumb(canvasBounds.width);
            this.horizontalBar.setPageIncrement(canvasBounds.width);
        } else {
            this.horizontalBar.setEnabled(false);
            if (this.curX != 0) {
                this.curX = 0;
                this.redraw();
            }
        }
        int height = Math.round(this.imageData.height);
        if (height > canvasBounds.height) {
            this.verticalBar.setEnabled(true);
            this.verticalBar.setMaximum(height);
            this.verticalBar.setThumb(canvasBounds.height);
            this.verticalBar.setPageIncrement(canvasBounds.height);
        } else {
            this.verticalBar.setEnabled(false);
            if (this.curY != 0) {
                this.curY = 0;
                this.redraw();
            }
        }
    }

    private void setVScrollBar(int iPos) {
        if (this.sync) {
            if (this.image == null) {
                return;
            }
            int width = Math.round(this.imageData.width);
            int height = Math.round(this.imageData.height);
            this.scroll(this.curX, -iPos, this.curX, this.curY, width, height, false);
            this.curY = -iPos;
            this.verticalBar.setSelection(iPos);
        }
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle canvasBounds = this.getClientArea();
        int width = Math.round(this.imageData.width);
        int height = Math.round(this.imageData.height);
        if (width > canvasBounds.width) {
            int x = -scrollBar.getSelection();
            if (x + width < canvasBounds.width) {
                x = canvasBounds.width - width;
            }
            this.scroll(x, this.curY, this.curX, this.curY, width, height, false);
            this.curX = x;
        }
    }

    private void scrollVertically(ScrollBar scrollBar) {
        if (this.image != null) {
            Rectangle canvasBounds = this.getClientArea();
            int width = Math.round(this.imageData.width);
            int height = Math.round(this.imageData.height);
            if (height > canvasBounds.height) {
                int y = -scrollBar.getSelection();
                if (y + height < canvasBounds.height) {
                    y = canvasBounds.height - height;
                }
                this.scroll(this.curX, y, this.curX, this.curY, width, height, false);
                if (this.sync && this.current != null && this.current == this.target && this.targetUrl.equals(this.target.getURL())) {
                    IModelServiceScrollManager scrollManager = this.target.getScrollManager();
                    switch (scrollManager.getScrollType()) {
                        case 0: {
                            int targetHeight = scrollManager.getSize(true).getWholeSizeY();
                            double ratio = (double)targetHeight / (double)(height - this.horizontalBar.getSize().y);
                            scrollManager.absoluteCoordinateScroll((int)((double)(this.curY - y) * ratio), false);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            ModelServiceSizeInfo sizeInfo = scrollManager.getSize(false);
                            int page = Math.abs(y / sizeInfo.getViewSizeY()) + 1;
                            if (page < 1) {
                                page = 1;
                            } else if (page > scrollManager.getLastPageNumber()) {
                                page = scrollManager.getCurrentPageNumber();
                            }
                            if (page == scrollManager.getCurrentPageNumber()) break;
                            scrollManager.jumpToPage(page, false);
                        }
                    }
                }
                this.curY = y;
            }
        }
    }

    public void setCurrentModelService(IModelService currentModelService) {
        this.current = currentModelService;
    }

    public void showImage(ImageData imageData, IModelService targetModelService) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.imageData = imageData;
        this.target = targetModelService;
        if (this.current == null) {
            this.current = this.target;
        }
        this.targetUrl = this.target != null ? this.target.getURL() : null;
        if (this.imageData != null) {
            try {
                this.image = new Image((Device)this.display, this.imageData);
            }
            catch (SWTException se) {
                se.printStackTrace();
            }
        }
        this.redraw();
        this.resetScrollBars();
    }

    public void clear() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        if (this.imageData != null) {
            this.imageData = null;
        }
        this.highlightTargetList = new ArrayList<IPositionSize>();
        this.resetScrollBars();
        this.redraw();
    }

    public void highlight(List<IPositionSize> highlightList) {
        if (highlightList != null) {
            int topY = -1;
            for (IPositionSize ips : highlightList) {
                if (topY >= 0 && topY <= ips.getY()) continue;
                topY = ips.getY();
            }
            if (topY >= 0) {
                Rectangle canvasBounds = this.getClientArea();
                int height = Math.round(this.imageData.height);
                if (height > canvasBounds.height) {
                    if (height - topY < canvasBounds.height) {
                        topY = height - canvasBounds.height;
                    }
                    this.setVScrollBar(topY);
                }
            }
            this.highlightTargetList = highlightList;
        }
        this.redraw();
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }
}

