/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.eval;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.eval.EvaluationResultImpl;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultLowVision
extends EvaluationResultImpl {
    private int count = 0;

    public CheckResultLowVision() {
        this.setSummaryReportUrl("about:blank");
        this.setShowAllGuidelineItems(true);
    }

    public void setFrameOffsetToProblems(IPageImage[] framePageImages) {
        if (framePageImages != null) {
            int[] frameOffset = new int[framePageImages.length];
            frameOffset[0] = 0;
            int i = 1;
            while (i < framePageImages.length) {
                frameOffset[i] = frameOffset[i - 1] + framePageImages[i - 1].getHeight();
                ++i;
            }
            Iterator i2 = this.getProblemList().iterator();
            while (i2.hasNext()) {
                try {
                    IProblemItemImage tmpP = (IProblemItemImage)i2.next();
                    int frameId = tmpP.getFrameId();
                    if (frameId <= -1 || frameId >= frameOffset.length) continue;
                    tmpP.setFrameOffset(frameOffset[frameId]);
                    tmpP.setY(tmpP.getY() + frameOffset[frameId]);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void addProblemItems(Collection<IProblemItem> c) {
        this.stripProblem(c);
        super.addProblemItems(c);
    }

    public void setProblemList(List<IProblemItem> problemList) {
        this.count = 0;
        this.stripProblem(problemList);
        super.setProblemList(problemList);
    }

    private void stripProblem(Collection<IProblemItem> c) {
        GuidelineHolder holder = GuidelineHolder.getInstance();
        Iterator<IProblemItem> i = c.iterator();
        while (i.hasNext()) {
            try {
                IProblemItem tmpItem = i.next();
                if (holder.isMatchedCheckItem(tmpItem.getEvaluationItem())) {
                    tmpItem.setSerialNumber(this.count);
                    ++this.count;
                    continue;
                }
                i.remove();
            }
            catch (Exception exception) {
                i.remove();
            }
        }
    }
}

